/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Label;

public class Style
extends AbstractComponent {
    private String _src;

    public Style() {
    }

    public Style(String src) {
        this.setSrc(src);
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.invalidate();
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Label)) {
            throw new UiException("Unsupported child for style: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void redraw(Writer out) throws IOException {
        if (this._src != null) {
            out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            out.write(this.getDesktop().getExecution().encodeURL(this._src));
            out.write("\" id=\"");
            out.write(this.getUuid());
            out.write("\"/>");
        } else {
            out.write("<style type=\"text/css\" id=\"");
            out.write(this.getUuid());
            out.write("\">");
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                out.write(((Label)((Object)it.next())).getValue());
            }
            out.write("</style>");
        }
    }
}

