/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.ListIterator;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Radio;
import org.zkoss.zul.impl.XulElement;

public class Radiogroup
extends XulElement {
    private String _orient = "horizontal";
    private String _name = this.genGroupName();
    private int _jsel = -1;
    private transient EventListener _listener;

    public Radiogroup() {
        this.init();
    }

    private void init() {
        this._listener = new EventListener(){

            public void onEvent(Event event) {
                Events.sendEvent((Component)Radiogroup.this, (Event)event);
            }

            public boolean isAsap() {
                return Events.isListenerAvailable((Component)Radiogroup.this, (String)"onCheck", (boolean)true);
            }
        };
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public Radio getItemAtIndex(int index) {
        return (Radio)((Object)this.getChildren().get(index));
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel < 0) {
            jsel = -1;
        }
        if (this._jsel != jsel) {
            if (jsel < 0) {
                this.getSelectedItem().setSelected(false);
            } else {
                this.getItemAtIndex(jsel).setSelected(true);
            }
        }
    }

    public Radio getSelectedItem() {
        return this._jsel >= 0 ? this.getItemAtIndex(this._jsel) : null;
    }

    public void setSelectedItem(Radio item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            item.setSelected(true);
        }
    }

    public Radio appendItem(String label, String value) {
        Radio item = new Radio();
        item.setLabel(label);
        item.setValue(value);
        item.setParent((Component)this);
        return item;
    }

    public Radio removeItemAt(int index) {
        Radio item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Radio) {
            if (super.insertBefore(child, insertBefore)) {
                Radio childItem = (Radio)child;
                if (this._jsel >= 0 && childItem.isSelected()) {
                    childItem.setSelected(false);
                } else {
                    this.fixSelectedIndex();
                }
                child.addEventListener("onCheck", this._listener);
                return true;
            }
            return false;
        }
        throw new UiException("Unsupported child for Radiogroup: " + child);
    }

    public boolean removeChild(Component child) {
        boolean ret = super.removeChild(child);
        if (ret && child instanceof Radio) {
            Radio childItem = (Radio)child;
            if (childItem.isSelected()) {
                this._jsel = -1;
            } else if (this._jsel > 0) {
                this.fixSelectedIndex();
            }
            child.removeEventListener("onCheck", this._listener);
        }
        return ret;
    }

    void fixSelectedIndex() {
        this._jsel = -1;
        int j = 0;
        ListIterator it = this.getChildren().listIterator(j);
        while (it.hasNext()) {
            Radio item = (Radio)((Object)it.next());
            if (item.isSelected()) {
                this._jsel = j;
                return;
            }
            ++j;
        }
    }

    private String genGroupName() {
        return Strings.encode((StringBuffer)new StringBuffer(16).append("_pg"), (int)System.identityHashCode((Object)this)).toString();
    }

    public Object clone() {
        Radiogroup clone = (Radiogroup)((Object)super.clone());
        Radiogroup.fixClone(clone);
        return clone;
    }

    private static void fixClone(Radiogroup clone) {
        if (clone._name.startsWith("_pg")) {
            clone._name = clone.genGroupName();
        }
        Iterator it = clone.getChildren().iterator();
        while (it.hasNext()) {
            Radio child = (Radio)((Object)it.next());
            child.removeEventListener("onCheck", clone._listener);
        }
        clone.init();
        clone.afterUnmarshal();
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Radio child = (Radio)((Object)it.next());
            child.addEventListener("onCheck", this._listener);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
    }
}

