/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Intbox
extends FormatInputElement {
    public Intbox() {
        this.setCols(11);
    }

    public Intbox(int value) throws WrongValueException {
        this();
        this.setValue(new Integer(value));
    }

    public Integer getValue() throws WrongValueException {
        return (Integer)this.getRawValue();
    }

    public int intValue() throws WrongValueException {
        Object val = this.getRawValue();
        return val != null ? (Integer)val : 0;
    }

    public void setValue(Integer value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        String val = this.toNumberOnly(value);
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int v;
            int j = val.indexOf(37);
            if (j <= 0) {
                return j == 0 ? new Integer(0) : Integer.valueOf(val);
            }
            int len = val.length();
            for (v = Integer.parseInt(val.substring(0, j)); j < len && v != 0; v /= 100, ++j) {
                if (val.charAt(j) == '%') {
                    continue;
                }
                throw new WrongValueException((Component)this, MZul.INTEGER_REQUIRED, (Object)value);
            }
            return new Integer(v);
        }
        catch (NumberFormatException ex) {
            throw new WrongValueException((Component)this, MZul.INTEGER_REQUIRED, (Object)value);
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }
}

