/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zk.ui.ext.render.MultiBranch;
import org.zkoss.zul.Caption;
import org.zkoss.zul.impl.XulElement;

public class Groupbox
extends XulElement {
    private Caption _caption;
    private boolean _open = true;
    private boolean _closable = true;

    public Caption getCaption() {
        return this._caption;
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("z:open", this._open);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("z:closable", closable);
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onOpen");
        String clkattrs = this.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (!this._closable) {
            sb.append(" z:closable=\"false\"");
        }
        return sb.toString();
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + (Object)((Object)this));
            }
            if (!this.getChildren().isEmpty()) {
                insertBefore = (Component)this.getChildren().get(0);
            }
            this._caption = (Caption)child;
            this.invalidate();
        } else if (insertBefore instanceof Caption) {
            throw new UiException("caption must be the first child");
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Caption) {
            this._caption = null;
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements MultiBranch,
    Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Groupbox.this);
        }

        public boolean inDifferentBranch(Component child) {
            return child instanceof Caption;
        }

        public void setOpenByClient(boolean open) {
            Groupbox.this._open = open;
        }
    }
}

