/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.math.BigDecimal;
import org.zkoss.math.BigDecimals;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Decimalbox
extends FormatInputElement {
    public static final int AUTO = -1000000000;
    private int _scale = -1000000000;

    public Decimalbox() {
        this.setCols(11);
    }

    public Decimalbox(BigDecimal value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public BigDecimal getValue() throws WrongValueException {
        return (BigDecimal)this.getRawValue();
    }

    public void setValue(BigDecimal value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public int getScale() {
        return this._scale;
    }

    public void setScale(int scale) {
        this._scale = scale;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        String val = this.toNumberOnly(value);
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            BigDecimal bd;
            int j = val.indexOf(37);
            BigDecimal bigDecimal = j == 0 ? BigDecimals.ZERO : (bd = new BigDecimal(j < 0 ? val : val.substring(0, j)));
            if (this._scale != -1000000000) {
                bd = bd.setScale(this._scale);
            }
            if (j <= 0) {
                return bd;
            }
            BigDecimal hundred = new BigDecimal(100);
            int len = val.length();
            while (j < len && bd.signum() != 0) {
                if (val.charAt(j) != '%') {
                    throw new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value);
                }
                bd = bd.divide(hundred, this._scale == -1000000000 ? bd.scale() + 2 : this._scale, 6);
                ++j;
            }
            return bd;
        }
        catch (NumberFormatException ex) {
            throw new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value);
        }
    }

    protected String coerceToString(Object value) {
        return this.formatNumber(value, "0.##########");
    }
}

