/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.ext.client.Checkable;
import org.zkoss.zul.impl.LabelImageElement;

public class Checkbox
extends LabelImageElement {
    private String _name;
    private boolean _checked;
    private boolean _disabled;
    private boolean _readonly;

    public Checkbox() {
    }

    public Checkbox(String label) {
        this.setLabel(label);
    }

    public Checkbox(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readOnly", this._readonly);
        }
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        if (this._checked != checked) {
            this._checked = checked;
            this.smartUpdate("checked", this._checked);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public String getLabelAttrs() {
        String style = HTMLs.getTextRelevantStyle((String)this.getRealStyle());
        return style.length() > 0 ? "style=\"" + style + '\"' : "";
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this.getName());
        if (this.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
        }
        if (this.isReadonly()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"readonly", (String)"readonly");
        }
        if (this.isChecked()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"checked", (String)"checked");
        }
        return sb.toString();
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onFocus");
        this.appendAsapAttr(sb, "onBlur");
        this.appendAsapAttr(sb, "onCheck");
        this.appendAsapAttr(sb, "onRightClick");
        return sb.toString();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends LabelImageElement.ExtraCtrl
    implements Checkable {
        protected ExtraCtrl() {
            super(Checkbox.this);
        }

        public void setCheckedByClient(boolean checked) {
            Checkbox.this._checked = checked;
        }
    }
}

