/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Splitter;
import org.zkoss.zul.impl.XulElement;

public class Box
extends XulElement {
    private String _spacing;

    public Box() {
        this.setMold("vertical");
    }

    public Box(String orient) {
        this.setOrient(orient);
    }

    public String getOrient() {
        return this.getMold();
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        this.setMold(orient);
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String spacing) {
        if (spacing != null && spacing.length() == 0) {
            spacing = null;
        }
        if (!Objects.equals((Object)this._spacing, (Object)spacing)) {
            this._spacing = spacing;
            this.invalidate();
        }
    }

    public String getChildExteriorAttrs() {
        StringBuffer sb = new StringBuffer(32);
        boolean vert = "vertical".equals(this.getOrient());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"class", (String)(vert ? "vbox" : "hbox"));
        if (this._spacing != null) {
            sb.append("style=\"");
            if (vert) {
                sb.append("padding-bottom:").append(this._spacing);
            } else {
                sb.append("padding-right:").append(this._spacing);
            }
            sb.append('\"');
        }
        return sb.toString();
    }

    public String getSplitterExteriorAttrs() {
        boolean vert = "vertical".equals(this.getOrient());
        return (vert ? " height" : " width") + "=\"8px\"";
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
        String chdattrs;
        String string = chdattrs = child instanceof Splitter ? this.getSplitterExteriorAttrs() : this.getChildExteriorAttrs();
        if ("vertical".equals(this.getOrient())) {
            StringBuffer sb = new StringBuffer(16).append("<tr id=\"").append(child.getUuid()).append("!chdextr\"><td ").append(chdattrs).append('>');
            out.insert(0, sb);
            out.append("</td></tr>");
        } else {
            String width;
            StringBuffer sb = new StringBuffer(32).append("<td id=\"").append(child.getUuid()).append("!chdextr\"");
            if (child instanceof HtmlBasedComponent && (width = ((HtmlBasedComponent)child).getWidth()) != null) {
                sb.append(" width=\"").append(width).append('\"');
            }
            sb.append(chdattrs).append('>');
            out.insert(0, sb);
            out.append("</td>");
        }
    }
}

