/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ResourceInfo;

public abstract class ResourceLoader
implements Loader {
    private static final Log log = Log.lookup((Class)ResourceLoader.class);

    protected ResourceLoader() {
    }

    protected abstract Object parse(String var1, File var2, Object var3) throws Exception;

    protected abstract Object parse(String var1, URL var2, Object var3) throws Exception;

    public boolean shallCheck(Object src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    public long getLastModified(Object src) {
        ResourceInfo si = (ResourceInfo)src;
        if (si.url != null) {
            String protocol = si.url.getProtocol().toLowerCase();
            if (!("http".equals(protocol) || "https".equals(protocol) || "ftp".equals(protocol))) {
                try {
                    return si.url.openConnection().getLastModified();
                }
                catch (Throwable ex) {
                    return -1L;
                }
            }
            return -1L;
        }
        return si.file.lastModified();
    }

    public Object load(Object src) throws Exception {
        ResourceInfo si = (ResourceInfo)src;
        if (si.url != null) {
            return this.parse(si.path, si.url, si.extra);
        }
        if (!si.file.exists()) {
            if (log.debugable()) {
                log.debug("Not found: " + si.file);
            }
            return null;
        }
        if (log.debugable()) {
            log.debug("Loading " + si.file);
        }
        try {
            return this.parse(si.path, si.file, si.extra);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }
}

