/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.idom.Verifier;
import org.zkoss.idom.impl.AbstractItem;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.lang.SystemException;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.Maps;

public class ProcessingInstruction
extends AbstractItem
implements org.w3c.dom.ProcessingInstruction {
    protected String _target;
    protected String _rawData;

    public ProcessingInstruction(String target, String data) {
        this.setTarget(target);
        this.setData(data);
    }

    public ProcessingInstruction(String target, Map data) {
        this.setTarget(target);
        this.setData(data);
    }

    protected ProcessingInstruction() {
    }

    public final String getTarget() {
        return this._target;
    }

    public final void setTarget(String target) {
        this.checkWritable();
        if (!Objects.equals(this._target, target)) {
            Verifier.checkPITarget(target, this.getLocator());
            this._target = target;
            this.setModified();
        }
    }

    public final String getData() {
        return this._rawData;
    }

    public final void setData(String data) {
        this.checkWritable();
        if (data == null) {
            data = "";
        }
        if (!Objects.equals(this._rawData, data)) {
            this._rawData = data;
            this.setModified();
        }
    }

    public final Map parseData() {
        Map map = ProcessingInstruction.parseToMap(null, this.getData());
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public final void setData(Map data) {
        String notAllowed = "= '\"";
        Iterator it = data.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int j = Strings.anyOf(key, "= '\"", 0);
            if (j >= key.length()) continue;
            char cc = key.charAt(j);
            throw new SystemException(MCommon.ILLEGAL_CHAR, cc + " (0x" + Integer.toHexString(cc) + ')');
        }
        this.setData(Maps.toString(data, '\"', ' '));
    }

    public static final Map parseToMap(Map map, String rawData) {
        if (rawData == null || rawData.trim().length() == 0) {
            return map;
        }
        return Maps.parse(map, rawData, ' ', '\"');
    }

    public final String getName() {
        return this.getTarget();
    }

    public final void setName(String name) {
        this.setTarget(name);
    }

    public final String getText() {
        return this.getData();
    }

    public final void setText(String text) {
        this.setData(text);
    }

    public final short getNodeType() {
        return 7;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64).append("[PI: ").append(this._target);
        if (this._rawData.length() > 0) {
            sb.append(' ').append(this._rawData);
        }
        return sb.append(']').toString();
    }
}

