# [UI Router for Angular 1](https://ui-router.github.io/ng1/docs/latest)

#### The de-facto solution to flexible routing in angular 1

<div style="display: flex;">

<iframe style="display: inline-block;" src="https://ghbtns.com/github-btn.html?user=angular-ui&repo=ui-router&type=fork&count=true&size=medium" frameborder="0" scrolling="0" width="110px" height="20px"></iframe>
<iframe style="display: inline-block;" src="https://ghbtns.com/github-btn.html?user=angular-ui&repo=ui-router&type=star&count=true&size=medium" frameborder="0" scrolling="0" width="110px" height="20px"></iframe>
[![Build Status](https://travis-ci.org/angular-ui/ui-router.svg?branch=master)](https://travis-ci.org/angular-ui/ui-router)

</div>


Angular UI-Router is a client-side [Single Page Application](https://en.wikipedia.org/wiki/Single-page_application) 
routing framework for [AngularJS](http://angularjs.org).  

**[View on Github](http://github.com/angular-ui/ui-router) |**
**[Tutorials](https://ui-router.github.io/ng1/tutorials/)** |
**[Guides](https://ui-router.github.io/guide) |**
**[Sample App](http://ui-router.github.io/resources/sampleapp/) |**
**[Wiki](https://github.com/angular-ui/ui-router/wiki) |**
**[FAQ](https://github.com/angular-ui/ui-router/wiki/Frequently-Asked-Questions)**
  
#### API Documentation Organization

The documentation is arranged according to API concern, such as `url`, `resolve`, and `core`.
For a list of services and objects that can be injectable, see the [`injectables` section](./injectables.html).

By default, only the public UI-Router API is shown.
To view both public API and the internal APIs, check the "Internal UI-Router API" checkbox.
  
#### Typescript

UI-Router is written in Typescript.
The API documentation is generated using [TypeDoc](https://github.com/TypeStrong/typedoc).
The documentation reflects the Typescript classes, interfaces, and parameter types information embedded in the source code.

#### Contributing

Angular UI-Router depends on the framework agnostic `@uirouter/core`.
To contribute to the documentation, please submit a PR to either 
[@uirouter/angularjs](http://github.com/angular-ui/ui-router)
or
[@uirouter/core](http://github.com/ui-router/core).
To find where a specific piece of documentation is written, follow the links that say:
 > _Defined in ui-router/somedir/somefile.ts_


