/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.tynamo.security.services.PageService;
import org.tynamo.security.services.impl.SecurityFilterChain;

public class SecurityConfiguration
implements HttpServletRequestFilter {
    private SecurityManager securityManager;
    private final ServletContext servletContext;
    private final PageService pageService;
    private Map<String, SecurityFilterChain> chainMap = new LinkedHashMap<String, SecurityFilterChain>();
    private PatternMatcher pathMatcher = new AntPathMatcher(){

        public boolean matches(String pattern, String source) {
            return super.matches(pattern, source.toLowerCase());
        }
    };

    public SecurityConfiguration(ApplicationGlobals applicationGlobals, WebSecurityManager securityManager, PageService pageService, Collection<SecurityFilterChain> chains) {
        this.securityManager = securityManager;
        this.pageService = pageService;
        this.servletContext = applicationGlobals.getServletContext();
        for (SecurityFilterChain chain : chains) {
            this.chainMap.put(chain.getPath(), chain);
        }
    }

    public boolean service(HttpServletRequest originalRequest, HttpServletResponse response, final HttpServletRequestHandler handler) throws IOException {
        if (originalRequest instanceof ShiroHttpServletRequest) {
            return handler.service(originalRequest, response);
        }
        ShiroHttpServletRequest request = new ShiroHttpServletRequest(originalRequest, this.servletContext, true);
        String requestURI = this.pageService.getLocalelessPathWithinApplication();
        SecurityFilterChain configureChain = null;
        for (String path : this.chainMap.keySet()) {
            if (!this.pathMatcher.matches(path, requestURI)) continue;
            configureChain = this.chainMap.get(path);
            break;
        }
        final SecurityFilterChain chain = configureChain;
        ThreadContext.bind((SecurityManager)this.securityManager);
        WebSubject subject = new WebSubject.Builder(this.securityManager, (ServletRequest)originalRequest, (ServletResponse)response).buildWebSubject();
        return (Boolean)subject.execute((Callable)new Callable<Boolean>((HttpServletRequest)request, response){
            final /* synthetic */ HttpServletRequest val$request;
            final /* synthetic */ HttpServletResponse val$response;
            {
                this.val$request = httpServletRequest;
                this.val$response = httpServletResponse;
            }

            @Override
            public Boolean call() throws Exception {
                if (chain == null) {
                    return handler.service(this.val$request, this.val$response);
                }
                boolean handled = chain.getHandler().service(this.val$request, this.val$response);
                return handled || handler.service(this.val$request, this.val$response);
            }
        });
    }

    private static final class HandlerFilterChain
    implements FilterChain {
        private HttpServletRequestHandler handler;
        private List<Filter> filters;
        private int index = 0;

        HandlerFilterChain(HttpServletRequestHandler handler, List<Filter> filters) {
            this.handler = handler;
            this.filters = filters;
            this.index = 0;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.filters == null || this.filters.size() == this.index) {
                this.handler.service((HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                this.filters.get(this.index++).doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

