/*
 * Decompiled with CFR 0.152.
 */
package tachyon.heartbeat;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.heartbeat.HeartbeatContext;
import tachyon.heartbeat.HeartbeatExecutor;
import tachyon.heartbeat.HeartbeatTimer;
import tachyon.heartbeat.SleepingTimer;
import tachyon.util.CommonUtils;

public final class HeartbeatThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final String mThreadName;
    private final HeartbeatExecutor mExecutor;
    private HeartbeatTimer mTimer;

    public HeartbeatThread(String threadName, HeartbeatExecutor executor, long intervalMs) {
        this.mThreadName = threadName;
        this.mExecutor = (HeartbeatExecutor)Preconditions.checkNotNull((Object)executor);
        Class<HeartbeatTimer> timerClass = HeartbeatContext.getTimerClass(threadName);
        try {
            this.mTimer = CommonUtils.createNewClassInstance(timerClass, new Class[]{String.class, Long.TYPE}, new Object[]{threadName, intervalMs});
        }
        catch (Exception e) {
            String msg = "timer class could not be instantiated";
            LOG.error("{} : {} , {}", new Object[]{msg, threadName, e});
            this.mTimer = new SleepingTimer(threadName, intervalMs);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.mThreadName);
        try {
            while (!Thread.interrupted()) {
                this.mTimer.tick();
                this.mExecutor.heartbeat();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in heartbeat executor, Heartbeat Thread shutting down", (Throwable)e);
        }
    }
}

