/*
 * Decompiled with CFR 0.152.
 */
package tachyon.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.exception.TachyonExceptionType;
import tachyon.thrift.TachyonTException;

public class TachyonException
extends Exception {
    private TachyonExceptionType mType;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    public TachyonException(TachyonTException te) {
        super(te.getMessage());
        this.mType = TachyonExceptionType.valueOf(te.type);
    }

    protected TachyonException(TachyonExceptionType type, Throwable cause) {
        super(cause);
        this.mType = type;
    }

    protected TachyonException(TachyonExceptionType type, String message) {
        super(message);
        this.mType = type;
    }

    protected TachyonException(TachyonExceptionType type, String message, Throwable cause) {
        super(message, cause);
        this.mType = type;
    }

    public TachyonExceptionType getType() {
        return this.mType;
    }

    public TachyonTException toTachyonTException() {
        return new TachyonTException(this.mType.name(), this.getMessage());
    }

    public static <T extends TachyonException> void unwrap(TachyonException e, Class<T> throwClass) throws T {
        try {
            TachyonException throwInstance = (TachyonException)throwClass.getConstructor(String.class, Throwable.class).newInstance(e.getMessage(), e);
            if (e.getType() == throwInstance.getType()) {
                throw throwInstance;
            }
        }
        catch (ReflectiveOperationException roe) {
            LOG.error("Class passed to unwrap is invalid: ", (Object)throwClass.getName());
        }
    }
}

