/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.table;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.table.RawColumn;
import tachyon.thrift.RawTableInfo;
import tachyon.util.io.BufferUtils;

public class RawTable {
    private final TachyonFS mTachyonFS;
    private final RawTableInfo mRawTableInfo;

    public RawTable(TachyonFS tachyonClient, RawTableInfo rawTableInfo) {
        this.mTachyonFS = tachyonClient;
        this.mRawTableInfo = rawTableInfo;
    }

    public int getColumns() {
        return this.mRawTableInfo.getColumns();
    }

    public long getId() {
        return this.mRawTableInfo.getId();
    }

    public ByteBuffer getMetadata() {
        return BufferUtils.cloneByteBuffer(this.mRawTableInfo.metadata);
    }

    public String getName() {
        return this.mRawTableInfo.getName();
    }

    public String getPath() {
        return this.mRawTableInfo.getPath();
    }

    public RawColumn getRawColumn(int columnIndex) {
        Preconditions.checkArgument((columnIndex >= 0 && columnIndex < this.mRawTableInfo.getColumns() ? 1 : 0) != 0, (Object)(this.mRawTableInfo.getPath() + " does not have column " + columnIndex + ". It has " + this.mRawTableInfo.getColumns() + " columns."));
        return new RawColumn(this.mTachyonFS, this, columnIndex);
    }

    public void updateMetadata(ByteBuffer metadata) throws IOException {
        this.mTachyonFS.updateRawTableMetadata(this.mRawTableInfo.getId(), metadata);
        this.mRawTableInfo.setMetadata(BufferUtils.cloneByteBuffer(metadata));
    }
}

