/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.lineage;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.MasterClientBase;
import tachyon.conf.TachyonConf;
import tachyon.exception.TachyonException;
import tachyon.job.CommandLineJob;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.LineageInfo;
import tachyon.thrift.LineageMasterService;
import tachyon.thrift.TachyonTException;

public final class LineageMasterClient
extends MasterClientBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private LineageMasterService.Client mClient = null;

    public LineageMasterClient(InetSocketAddress masterAddress, TachyonConf tachyonConf) {
        super(masterAddress, tachyonConf);
    }

    @Override
    protected String getServiceName() {
        return "LineageMaster";
    }

    @Override
    protected void afterConnect() {
        this.mClient = new LineageMasterService.Client(this.mProtocol);
    }

    public synchronized long createLineage(List<String> inputFiles, List<String> outputFiles, CommandLineJob job) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.createLineage(inputFiles, outputFiles, job.generateCommandLineJobInfo());
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean deleteLineage(long lineageId, boolean cascade) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.deleteLineage(lineageId, cascade);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized long reinitializeFile(String path, long blockSizeBytes, long ttl) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.reinitializeFile(path, blockSizeBytes, ttl);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized void asyncCompleteFile(long fileId) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                this.mClient.asyncCompleteFile(fileId);
                return;
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized List<LineageInfo> getLineageInfoList() throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getLineageInfoList();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }
}

