/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystemCore;
import tachyon.client.file.options.GetInfoOptions;
import tachyon.client.file.options.OpenOptions;
import tachyon.exception.TachyonException;
import tachyon.util.CommonUtils;

public final class TachyonFileSystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private TachyonFileSystemUtils() {
    }

    public static boolean waitCompleted(TachyonFileSystemCore tfs, TachyonURI uri) throws IOException, TachyonException, InterruptedException {
        return TachyonFileSystemUtils.waitCompleted(tfs, uri, -1L, TimeUnit.MILLISECONDS);
    }

    public static boolean waitCompleted(TachyonFileSystemCore tfs, TachyonURI uri, long timeout, TimeUnit tunit) throws IOException, TachyonException, InterruptedException {
        long deadline = System.currentTimeMillis() + tunit.toMillis(timeout);
        long pollPeriod = ClientContext.getConf().getLong("tachyon.user.file.waitcompleted.poll.ms");
        TachyonFile file = null;
        boolean completed = false;
        long timeleft = deadline - System.currentTimeMillis();
        long toSleep = 0L;
        while (!(completed || timeout > 0L && timeleft <= 0L)) {
            if (file == null && (file = tfs.openIfExists(uri, OpenOptions.defaults())) == null) {
                LOG.debug("The file {} being waited upon does not exist yet. Waiting for it to be created.", (Object)uri);
            }
            if (file != null) {
                completed = tfs.getInfo((TachyonFile)file, (GetInfoOptions)GetInfoOptions.defaults()).isCompleted;
            }
            if (timeout == 0L) {
                return completed;
            }
            if (completed) continue;
            toSleep = timeout < 0L || timeleft > pollPeriod ? pollPeriod : timeleft;
            CommonUtils.sleepMs(LOG, toSleep, true);
            timeleft = deadline - System.currentTimeMillis();
        }
        return completed;
    }
}

