/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DotTerminatedInputStream
extends InputStream {
    private InputStream in;
    private final byte[] lastBytes = new byte[]{13, 10};
    private int[] nextBytes = null;
    private boolean endReached = false;

    public DotTerminatedInputStream(InputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        if (this.nextBytes == null) {
            this.initNextBytes();
        }
        if (this.endReached) {
            return -1;
        }
        if (this.lastBytesAreCrLf() && this.nextBytesAreDotCrLf()) {
            this.endReached = true;
            return -1;
        }
        int result = this.nextBytes[0];
        if (result == -1) {
            throw new EOFException("Pre-mature end of <CRLF>.<CRLF> terminated data");
        }
        this.readWrappedStream();
        return result;
    }

    private void initNextBytes() throws IOException {
        this.nextBytes = new int[3];
        this.nextBytes[0] = this.in.read();
        this.nextBytes[1] = this.in.read();
        this.nextBytes[2] = this.in.read();
    }

    private boolean lastBytesAreCrLf() {
        return this.lastBytes[0] == 13 && this.lastBytes[1] == 10;
    }

    private boolean nextBytesAreDotCrLf() {
        return this.nextBytes[0] == 46 && this.nextBytes[1] == 13 && this.nextBytes[2] == 10;
    }

    private void readWrappedStream() throws IOException {
        this.lastBytes[0] = this.lastBytes[1];
        this.lastBytes[1] = (byte)this.nextBytes[0];
        this.nextBytes[0] = this.nextBytes[1];
        this.nextBytes[1] = this.nextBytes[2];
        this.nextBytes[2] = this.in.read();
    }
}

