/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.springframework.xml.xpath.XPathParseException;

public class XPathExpressionFactoryBean
implements FactoryBean<XPathExpression>,
InitializingBean {
    private Map<String, String> namespaces;
    private String expressionString;
    private XPathExpression expression;

    public void setExpression(String expression) {
        this.expressionString = expression;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void afterPropertiesSet() throws IllegalStateException, XPathParseException {
        Assert.notNull((Object)this.expressionString, (String)"expression is required");
        this.expression = CollectionUtils.isEmpty(this.namespaces) ? XPathExpressionFactory.createXPathExpression(this.expressionString) : XPathExpressionFactory.createXPathExpression(this.expressionString, this.namespaces);
    }

    public XPathExpression getObject() throws Exception {
        return this.expression;
    }

    public Class<? extends XPathExpression> getObjectType() {
        return XPathExpression.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

