/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathException;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Jaxp13XPathExpressionFactory {
    private static XPathFactory xpathFactory = XPathFactory.newInstance();

    Jaxp13XPathExpressionFactory() {
    }

    static XPathExpression createXPathExpression(String expression) {
        try {
            XPath xpath = Jaxp13XPathExpressionFactory.createXPath();
            javax.xml.xpath.XPathExpression xpathExpression = xpath.compile(expression);
            return new Jaxp13XPathExpression(xpathExpression);
        }
        catch (XPathExpressionException ex) {
            throw new XPathParseException("Could not compile [" + expression + "] to a XPathExpression: " + ex.getMessage(), ex);
        }
    }

    public static XPathExpression createXPathExpression(String expression, Map<String, String> namespaces) {
        try {
            XPath xpath = Jaxp13XPathExpressionFactory.createXPath();
            SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
            namespaceContext.setBindings(namespaces);
            xpath.setNamespaceContext(namespaceContext);
            javax.xml.xpath.XPathExpression xpathExpression = xpath.compile(expression);
            return new Jaxp13XPathExpression(xpathExpression);
        }
        catch (XPathExpressionException ex) {
            throw new XPathParseException("Could not compile [" + expression + "] to a XPathExpression: " + ex.getMessage(), ex);
        }
    }

    private static synchronized XPath createXPath() {
        return xpathFactory.newXPath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jaxp13XPathExpression
    implements XPathExpression {
        private final javax.xml.xpath.XPathExpression xpathExpression;

        private Jaxp13XPathExpression(javax.xml.xpath.XPathExpression xpathExpression) {
            this.xpathExpression = xpathExpression;
        }

        @Override
        public String evaluateAsString(Node node) {
            return (String)this.evaluate(node, XPathConstants.STRING);
        }

        @Override
        public List<Node> evaluateAsNodeList(Node node) {
            NodeList nodeList = (NodeList)this.evaluate(node, XPathConstants.NODESET);
            return this.toNodeList(nodeList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object evaluate(Node node, QName returnType) {
            try {
                javax.xml.xpath.XPathExpression xPathExpression = this.xpathExpression;
                synchronized (xPathExpression) {
                    return this.xpathExpression.evaluate(node, returnType);
                }
            }
            catch (XPathExpressionException ex) {
                throw new XPathException("Could not evaluate XPath expression:" + ex.getMessage(), ex);
            }
        }

        private List<Node> toNodeList(NodeList nodeList) {
            ArrayList<Node> result = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i));
            }
            return result;
        }

        @Override
        public double evaluateAsNumber(Node node) {
            return (Double)this.evaluate(node, XPathConstants.NUMBER);
        }

        @Override
        public boolean evaluateAsBoolean(Node node) {
            return (Boolean)this.evaluate(node, XPathConstants.BOOLEAN);
        }

        @Override
        public Node evaluateAsNode(Node node) {
            return (Node)this.evaluate(node, XPathConstants.NODE);
        }

        @Override
        public <T> T evaluateAsObject(Node node, NodeMapper<T> nodeMapper) throws XPathException {
            Node result = (Node)this.evaluate(node, XPathConstants.NODE);
            if (result != null) {
                try {
                    return nodeMapper.mapNode(result, 0);
                }
                catch (DOMException ex) {
                    throw new XPathException("Mapping resulted in DOMException", ex);
                }
            }
            return null;
        }

        @Override
        public <T> List<T> evaluate(Node node, NodeMapper<T> nodeMapper) throws XPathException {
            NodeList nodes = (NodeList)this.evaluate(node, XPathConstants.NODESET);
            ArrayList<T> results = new ArrayList<T>(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                try {
                    results.add(nodeMapper.mapNode(nodes.item(i), i));
                    continue;
                }
                catch (DOMException ex) {
                    throw new XPathException("Mapping resulted in DOMException", ex);
                }
            }
            return results;
        }
    }
}

