/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.matcher;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.matcher.AbstractSoapMessageMatcher;

public class SoapHeaderMatcher
extends AbstractSoapMessageMatcher {
    private final QName soapHeaderName;

    public SoapHeaderMatcher(QName soapHeaderName) {
        Assert.notNull((Object)soapHeaderName, (String)"'soapHeaderName' must not be null");
        this.soapHeaderName = soapHeaderName;
    }

    protected void match(SoapMessage soapMessage) throws IOException, AssertionError {
        SoapHeader soapHeader = soapMessage.getSoapHeader();
        AssertionErrors.assertTrue("SOAP message [" + soapMessage + "] does not contain SOAP header", soapHeader != null, "Envelope", soapMessage.getEnvelope().getSource());
        Iterator<SoapHeaderElement> soapHeaderElementIterator = soapHeader.examineAllHeaderElements();
        boolean found = false;
        while (soapHeaderElementIterator.hasNext()) {
            SoapHeaderElement soapHeaderElement = soapHeaderElementIterator.next();
            if (!this.soapHeaderName.equals(soapHeaderElement.getName())) continue;
            found = true;
            break;
        }
        AssertionErrors.assertTrue("SOAP header [" + this.soapHeaderName + "] not found", found, "Envelope", soapMessage.getEnvelope().getSource());
    }
}

