/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.pox.dom;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.pox.dom.DomPoxMessage;
import org.springframework.ws.pox.dom.DomPoxMessageException;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DomPoxMessageFactory
extends TransformerObjectSupport
implements WebServiceMessageFactory {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private String contentType = "application/xml";

    public DomPoxMessageFactory() {
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(false);
    }

    public void setContentType(String contentType) {
        Assert.hasLength((String)contentType, (String)"'contentType' must not be empty");
        this.contentType = contentType;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.documentBuilderFactory.setNamespaceAware(namespaceAware);
    }

    public void setValidating(boolean validating) {
        this.documentBuilderFactory.setValidating(validating);
    }

    public DomPoxMessage createWebServiceMessage() {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            Document request = documentBuilder.newDocument();
            return new DomPoxMessage(request, this.createTransformer(), this.contentType);
        }
        catch (ParserConfigurationException ex) {
            throw new DomPoxMessageException("Could not create message context", ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new DomPoxMessageException("Could not create transformer", ex);
        }
    }

    public DomPoxMessage createWebServiceMessage(InputStream inputStream) throws IOException {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            Document request = documentBuilder.parse(inputStream);
            return new DomPoxMessage(request, this.createTransformer(), this.contentType);
        }
        catch (ParserConfigurationException ex) {
            throw new DomPoxMessageException("Could not create message context", ex);
        }
        catch (SAXException ex) {
            throw new DomPoxMessageException("Could not parse request message", ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new DomPoxMessageException("Could not create transformer", ex);
        }
    }
}

