/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.ws.transport.jms.JmsReceiverConnection;
import org.springframework.ws.transport.support.SimpleWebServiceMessageReceiverObjectSupport;

public class JmsMessageReceiver
extends SimpleWebServiceMessageReceiverObjectSupport {
    public static final String DEFAULT_TEXT_MESSAGE_ENCODING = "UTF-8";
    private String textMessageEncoding = "UTF-8";
    private MessagePostProcessor postProcessor;

    public void setTextMessageEncoding(String textMessageEncoding) {
        this.textMessageEncoding = textMessageEncoding;
    }

    public void setPostProcessor(MessagePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    protected final void handleMessage(Message request, Session session) throws Exception {
        JmsReceiverConnection connection;
        if (request instanceof BytesMessage) {
            connection = new JmsReceiverConnection((BytesMessage)request, session);
        } else if (request instanceof TextMessage) {
            connection = new JmsReceiverConnection((TextMessage)request, this.textMessageEncoding, session);
        } else {
            throw new IllegalArgumentException("Wrong message type: [" + request.getClass() + "]. Only BytesMessages or TextMessages can be handled.");
        }
        connection.setPostProcessor(this.postProcessor);
        this.handleConnection(connection);
    }
}

