/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.messageid.UuidMessageIdStrategy;
import org.springframework.ws.soap.addressing.version.Addressing10;
import org.springframework.ws.soap.addressing.version.AddressingVersion;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;

public class ActionCallback
implements WebServiceMessageCallback {
    private final AddressingVersion version;
    private final URI action;
    private final URI to;
    private MessageIdStrategy messageIdStrategy;
    private EndpointReference from;
    private EndpointReference replyTo;
    private EndpointReference faultTo;

    public ActionCallback(String action) throws URISyntaxException {
        this(new URI(action), new Addressing10(), null);
    }

    public ActionCallback(URI action) {
        this(action, new Addressing10(), null);
    }

    public ActionCallback(URI action, AddressingVersion version) {
        this(action, version, null);
    }

    public ActionCallback(URI action, AddressingVersion version, URI to) {
        Assert.notNull((Object)action, (String)"'action' must not be null");
        Assert.notNull((Object)version, (String)"'version' must not be null");
        this.action = action;
        this.version = version;
        this.to = to;
        this.messageIdStrategy = new UuidMessageIdStrategy();
    }

    public AddressingVersion getVersion() {
        return this.version;
    }

    public MessageIdStrategy getMessageIdStrategy() {
        return this.messageIdStrategy;
    }

    public void setMessageIdStrategy(MessageIdStrategy messageIdStrategy) {
        Assert.notNull((Object)messageIdStrategy, (String)"'messageIdStrategy' must not be null");
        this.messageIdStrategy = messageIdStrategy;
    }

    public URI getAction() {
        return this.action;
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    protected URI getTo() {
        if (this.to == null) {
            TransportContext transportContext = TransportContextHolder.getTransportContext();
            if (transportContext != null && transportContext.getConnection() != null) {
                try {
                    return transportContext.getConnection().getUri();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw new IllegalStateException("Could not obtain connection URI from Transport Context");
        }
        return this.to;
    }

    public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
        Assert.isInstanceOf(SoapMessage.class, (Object)message);
        SoapMessage soapMessage = (SoapMessage)message;
        URI messageId = this.getMessageIdStrategy().newMessageId(soapMessage);
        MessageAddressingProperties map = new MessageAddressingProperties(this.getTo(), this.getFrom(), this.getReplyTo(), this.getFaultTo(), this.getAction(), messageId);
        this.version.addAddressingHeaders(soapMessage, map);
    }
}

