/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import javax.xml.bind.Element;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.oxm.jaxb.AbstractJaxbMarshaller;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StaxResult;
import org.springframework.xml.transform.StaxSource;
import org.springframework.xml.transform.TraxUtils;

public class Jaxb1Marshaller
extends AbstractJaxbMarshaller
implements BeanClassLoaderAware {
    private boolean validating = false;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean supports(Class clazz) {
        if (!Element.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (StringUtils.hasLength((String)this.getContextPath())) {
            String className = ClassUtils.getQualifiedName((Class)clazz);
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return false;
            }
            String packageName = className.substring(0, lastDotIndex);
            String[] contextPaths = StringUtils.tokenizeToStringArray((String)this.getContextPath(), (String)":");
            for (int i = 0; i < contextPaths.length; ++i) {
                if (!contextPaths[i].equals(packageName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected final JAXBContext createJaxbContext() throws JAXBException {
        if (!StringUtils.hasLength((String)this.getContextPath())) {
            throw new IllegalArgumentException("contextPath is required");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with context path [" + this.getContextPath() + "]"));
        }
        return this.classLoader != null ? JAXBContext.newInstance((String)this.getContextPath(), (ClassLoader)this.classLoader) : JAXBContext.newInstance((String)this.getContextPath());
    }

    protected void initJaxbUnmarshaller(Unmarshaller unmarshaller) throws JAXBException {
        unmarshaller.setValidating(this.validating);
    }

    public void marshal(Object graph, Result result) {
        if (TraxUtils.isStaxResult((Result)result)) {
            XMLStreamWriter streamWriter = TraxUtils.getXMLStreamWriter((Result)result);
            if (streamWriter != null) {
                result = new StaxResult(streamWriter);
            } else {
                XMLEventWriter eventWriter = TraxUtils.getXMLEventWriter((Result)result);
                if (eventWriter != null) {
                    result = new StaxResult(eventWriter);
                } else {
                    throw new IllegalArgumentException("StAXResult contains neither XMLStreamWriter nor XMLEventWriter");
                }
            }
        }
        try {
            this.createMarshaller().marshal(graph, result);
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    public Object unmarshal(Source source) {
        if (TraxUtils.isStaxSource((Source)source)) {
            XMLStreamReader streamReader = TraxUtils.getXMLStreamReader((Source)source);
            if (streamReader != null) {
                source = new StaxSource(streamReader);
            } else {
                XMLEventReader eventReader = TraxUtils.getXMLEventReader((Source)source);
                if (eventReader != null) {
                    source = new StaxSource(eventReader);
                } else {
                    throw new IllegalArgumentException("StAXSource contains neither XMLStreamReader nor XMLEventReader");
                }
            }
        }
        try {
            return this.createUnmarshaller().unmarshal(source);
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }
}

