/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.handler.AbstractDetectingUrlHandlerMapping;
import org.springframework.web.servlet.mvc.annotation.ServletAnnotationMappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationHandlerMapping
extends AbstractDetectingUrlHandlerMapping {
    private boolean useDefaultSuffixPattern = true;
    private final Map<Class, RequestMapping> cachedMappings = new HashMap<Class, RequestMapping>();

    public void setUseDefaultSuffixPattern(boolean useDefaultSuffixPattern) {
        this.useDefaultSuffixPattern = useDefaultSuffixPattern;
    }

    @Override
    protected String[] determineUrlsForHandler(String beanName) {
        ApplicationContext context = this.getApplicationContext();
        Class handlerType = context.getType(beanName);
        RequestMapping mapping = (RequestMapping)context.findAnnotationOnBean(beanName, RequestMapping.class);
        if (mapping != null) {
            this.cachedMappings.put(handlerType, mapping);
            LinkedHashSet<String> urls = new LinkedHashSet<String>();
            String[] typeLevelPatterns = mapping.value();
            if (typeLevelPatterns.length > 0) {
                String[] methodLevelPatterns = this.determineUrlsForHandlerMethods(handlerType);
                String[] stringArray = typeLevelPatterns;
                int n = typeLevelPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeLevelPattern = stringArray[n2];
                    if (!typeLevelPattern.startsWith("/")) {
                        typeLevelPattern = "/" + typeLevelPattern;
                    }
                    String[] stringArray2 = methodLevelPatterns;
                    int n3 = methodLevelPatterns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String methodLevelPattern = stringArray2[n4];
                        String combinedPattern = this.getPathMatcher().combine(typeLevelPattern, methodLevelPattern);
                        this.addUrlsForPath(urls, combinedPattern);
                        ++n4;
                    }
                    this.addUrlsForPath(urls, typeLevelPattern);
                    ++n2;
                }
                return StringUtils.toStringArray(urls);
            }
            return this.determineUrlsForHandlerMethods(handlerType);
        }
        if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) != null) {
            return this.determineUrlsForHandlerMethods(handlerType);
        }
        return null;
    }

    protected String[] determineUrlsForHandlerMethods(Class<?> handlerType) {
        Class<?>[] handlerTypes;
        Class<?>[] classArray;
        final LinkedHashSet urls = new LinkedHashSet();
        if (Proxy.isProxyClass(handlerType)) {
            classArray = handlerType.getInterfaces();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = handlerType;
        }
        Class<?>[] classArray3 = handlerTypes = classArray;
        int n = handlerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> currentHandlerType = classArray3[n2];
            ReflectionUtils.doWithMethods(currentHandlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                    if (mapping != null) {
                        String[] mappedPaths;
                        String[] stringArray = mappedPaths = mapping.value();
                        int n = mappedPaths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String mappedPath = stringArray[n2];
                            DefaultAnnotationHandlerMapping.this.addUrlsForPath(urls, mappedPath);
                            ++n2;
                        }
                    }
                }
            });
            ++n2;
        }
        return StringUtils.toStringArray(urls);
    }

    protected void addUrlsForPath(Set<String> urls, String path) {
        urls.add(path);
        if (this.useDefaultSuffixPattern && path.indexOf(46) == -1 && !path.endsWith("/")) {
            urls.add(String.valueOf(path) + ".*");
            urls.add(String.valueOf(path) + "/");
        }
    }

    @Override
    protected void validateHandler(Object handler, HttpServletRequest request) throws Exception {
        RequestMapping mapping = this.cachedMappings.get(handler.getClass());
        if (mapping == null) {
            mapping = (RequestMapping)AnnotationUtils.findAnnotation(handler.getClass(), RequestMapping.class);
        }
        if (mapping != null) {
            this.validateMapping(mapping, request);
        }
    }

    protected void validateMapping(RequestMapping mapping, HttpServletRequest request) throws Exception {
        RequestMethod[] mappedMethods = mapping.method();
        if (!ServletAnnotationMappingUtils.checkRequestMethod(mappedMethods, request)) {
            String[] supportedMethods = new String[mappedMethods.length];
            int i = 0;
            while (i < mappedMethods.length) {
                supportedMethods[i] = mappedMethods[i].name();
                ++i;
            }
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), supportedMethods);
        }
        String[] mappedParams = mapping.params();
        if (!ServletAnnotationMappingUtils.checkParameters(mappedParams, request)) {
            throw new UnsatisfiedServletRequestParameterException(mappedParams, request.getParameterMap());
        }
        Object[] mappedHeaders = mapping.headers();
        if (!ServletAnnotationMappingUtils.checkHeaders((String[])mappedHeaders, request)) {
            throw new ServletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])mappedHeaders, (String)", ") + "\" not met for actual request");
        }
    }
}

