/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.observation;

import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.contextpropagation.ObservationThreadLocalAccessor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.Conventions;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ReflectionUtils;

class MicrometerObservationRegistryTestExecutionListener
extends AbstractTestExecutionListener {
    public static final int ORDER = 2500;
    private static final Log logger = LogFactory.getLog(MicrometerObservationRegistryTestExecutionListener.class);
    private static final String PREVIOUS_OBSERVATION_REGISTRY = Conventions.getQualifiedAttributeName(MicrometerObservationRegistryTestExecutionListener.class, (String)"previousObservationRegistry");
    static final String DEPENDENCIES_ERROR_MESSAGE = "MicrometerObservationRegistryTestExecutionListener requires io.micrometer:micrometer-observation:1.10.8 or higher and io.micrometer:context-propagation:1.0.3 or higher.";
    static final String THREAD_LOCAL_ACCESSOR_CLASS_NAME = "io.micrometer.context.ThreadLocalAccessor";
    static final String OBSERVATION_THREAD_LOCAL_ACCESSOR_CLASS_NAME = "io.micrometer.observation.contextpropagation.ObservationThreadLocalAccessor";
    private static final @Nullable String ERROR_MESSAGE;

    public MicrometerObservationRegistryTestExecutionListener() {
        if (ERROR_MESSAGE != null) {
            throw new NoClassDefFoundError(ERROR_MESSAGE);
        }
    }

    @Override
    public final int getOrder() {
        return 2500;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        testContext.getApplicationContext().getBeanProvider(ObservationRegistry.class).ifAvailable(registry -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering ObservationRegistry from ApplicationContext in ObservationThreadLocalAccessor for test class " + testContext.getTestClass().getName()));
            }
            ObservationThreadLocalAccessor accessor = ObservationThreadLocalAccessor.getInstance();
            testContext.setAttribute(PREVIOUS_OBSERVATION_REGISTRY, accessor.getObservationRegistry());
            accessor.setObservationRegistry(registry);
        });
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        ObservationRegistry previousObservationRegistry = (ObservationRegistry)testContext.removeAttribute(PREVIOUS_OBSERVATION_REGISTRY);
        if (previousObservationRegistry != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Restoring ObservationRegistry in ObservationThreadLocalAccessor for test class " + testContext.getTestClass().getName()));
            }
            ObservationThreadLocalAccessor.getInstance().setObservationRegistry(previousObservationRegistry);
        }
    }

    static {
        String errorMessage = null;
        ClassLoader classLoader = MicrometerObservationRegistryTestExecutionListener.class.getClassLoader();
        String classToCheck = THREAD_LOCAL_ACCESSOR_CLASS_NAME;
        try {
            Class.forName(classToCheck, false, classLoader);
            classToCheck = OBSERVATION_THREAD_LOCAL_ACCESSOR_CLASS_NAME;
            Class<?> clazz = Class.forName(classToCheck, false, classLoader);
            Method method = ReflectionUtils.findMethod(clazz, (String)"getObservationRegistry");
            if (method == null) {
                errorMessage = classToCheck + ". Method getObservationRegistry() not found. MicrometerObservationRegistryTestExecutionListener requires io.micrometer:micrometer-observation:1.10.8 or higher and io.micrometer:context-propagation:1.0.3 or higher.";
            }
        }
        catch (Throwable ex) {
            errorMessage = classToCheck + ". MicrometerObservationRegistryTestExecutionListener requires io.micrometer:micrometer-observation:1.10.8 or higher and io.micrometer:context-propagation:1.0.3 or higher.";
        }
        ERROR_MESSAGE = errorMessage;
    }
}

