/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import org.springframework.util.Assert;

public class ExpectedCount {
    private final int minCount;
    private final int maxCount;

    private ExpectedCount(int minCount, int maxCount) {
        Assert.isTrue((minCount >= 0 ? 1 : 0) != 0, (String)"minCount >= 0 is required");
        Assert.isTrue((maxCount >= minCount ? 1 : 0) != 0, (String)"maxCount >= minCount is required");
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public static ExpectedCount once() {
        return new ExpectedCount(1, 1);
    }

    public static ExpectedCount twice() {
        return new ExpectedCount(2, 2);
    }

    public static ExpectedCount manyTimes() {
        return new ExpectedCount(1, Integer.MAX_VALUE);
    }

    public static ExpectedCount times(int count) {
        Assert.isTrue((count >= 1 ? 1 : 0) != 0, (String)"'count' must be >= 1");
        return new ExpectedCount(count, count);
    }

    public static ExpectedCount min(int min) {
        Assert.isTrue((min >= 1 ? 1 : 0) != 0, (String)"'min' must be >= 1");
        return new ExpectedCount(min, Integer.MAX_VALUE);
    }

    public static ExpectedCount max(int max) {
        Assert.isTrue((max >= 1 ? 1 : 0) != 0, (String)"'max' must be >= 1");
        return new ExpectedCount(1, max);
    }

    public static ExpectedCount never() {
        return new ExpectedCount(0, 0);
    }

    public static ExpectedCount between(int min, int max) {
        return new ExpectedCount(min, max);
    }
}

