/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public abstract class AbstractGenericWebContextLoader
extends AbstractContextLoader {
    private static final Log logger = LogFactory.getLog(AbstractGenericWebContextLoader.class);

    public final ConfigurableApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        if (!(mergedConfig instanceof WebMergedContextConfiguration)) {
            throw new IllegalArgumentException(String.format("Cannot load WebApplicationContext from non-web merged context configuration %s. Consider annotating your test class with @WebAppConfiguration.", mergedConfig));
        }
        WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Loading WebApplicationContext for merged context configuration %s.", webMergedConfig));
        }
        GenericWebApplicationContext context = new GenericWebApplicationContext();
        this.configureWebResources(context, webMergedConfig);
        this.prepareContext((ConfigurableApplicationContext)context, webMergedConfig);
        this.customizeBeanFactory(context.getDefaultListableBeanFactory(), webMergedConfig);
        this.loadBeanDefinitions(context, webMergedConfig);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
        this.customizeContext(context, webMergedConfig);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected void configureWebResources(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        String resourceBasePath = webMergedConfig.getResourceBasePath();
        DefaultResourceLoader resourceLoader = resourceBasePath.startsWith("classpath:") ? new DefaultResourceLoader() : new FileSystemResourceLoader();
        MockServletContext servletContext = new MockServletContext(resourceBasePath, (ResourceLoader)resourceLoader);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, context);
        context.setServletContext((ServletContext)servletContext);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory, WebMergedContextConfiguration webMergedConfig) {
    }

    protected abstract void loadBeanDefinitions(GenericWebApplicationContext var1, WebMergedContextConfiguration var2);

    protected void customizeContext(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
    }

    public final ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("AbstractGenericWebContextLoader does not support the loadContext(String... locations) method");
    }
}

