/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.NoProviderFoundException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import jakarta.validation.metadata.ExecutableDescriptor;
import jakarta.validation.metadata.MethodType;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class BeanValidationBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final boolean beanValidationPresent = ClassUtils.isPresent((String)"jakarta.validation.Validation", (ClassLoader)BeanValidationBeanRegistrationAotProcessor.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(BeanValidationBeanRegistrationAotProcessor.class);

    BeanValidationBeanRegistrationAotProcessor() {
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (beanValidationPresent) {
            return BeanValidationDelegate.processAheadOfTime(registeredBean);
        }
        return null;
    }

    private static class BeanValidationDelegate {
        @Nullable
        private static final Validator validator = BeanValidationDelegate.getValidatorIfAvailable();

        private BeanValidationDelegate() {
        }

        @Nullable
        private static Validator getValidatorIfAvailable() {
            Validator validator;
            block8: {
                ValidatorFactory validator2 = Validation.buildDefaultValidatorFactory();
                try {
                    validator = validator2.getValidator();
                    if (validator2 == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (validator2 != null) {
                            try {
                                validator2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoProviderFoundException ex) {
                        logger.info((Object)"No Bean Validation provider available - skipping validation constraint hint inference");
                        return null;
                    }
                }
                validator2.close();
            }
            return validator;
        }

        @Nullable
        public static BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
            if (validator == null) {
                return null;
            }
            Class beanClass = registeredBean.getBeanClass();
            HashSet validatedClasses = new HashSet();
            HashSet constraintValidatorClasses = new HashSet();
            BeanValidationDelegate.processAheadOfTime(beanClass, validatedClasses, constraintValidatorClasses);
            if (!validatedClasses.isEmpty() || !constraintValidatorClasses.isEmpty()) {
                return new AotContribution(validatedClasses, constraintValidatorClasses);
            }
            return null;
        }

        private static void processAheadOfTime(Class<?> clazz, Collection<Class<?>> validatedClasses, Collection<Class<? extends ConstraintValidator<?, ?>>> constraintValidatorClasses) {
            BeanDescriptor descriptor;
            Assert.notNull((Object)validator, (String)"Validator can't be null");
            try {
                descriptor = validator.getConstraintsForClass(clazz);
            }
            catch (RuntimeException ex) {
                if (KotlinDetector.isKotlinType(clazz) && ex instanceof ArrayIndexOutOfBoundsException) {
                    logger.warn((Object)("Skipping validation constraint hint inference for class " + clazz + " due to an ArrayIndexOutOfBoundsException at validator level"));
                } else if (ex instanceof TypeNotPresentException) {
                    logger.debug((Object)("Skipping validation constraint hint inference for class " + clazz + " due to a TypeNotPresentException at validator level: " + ex.getMessage()));
                } else {
                    logger.warn((Object)("Skipping validation constraint hint inference for class " + clazz), (Throwable)ex);
                }
                return;
            }
            BeanValidationDelegate.processExecutableDescriptor(descriptor.getConstrainedMethods(MethodType.NON_GETTER, new MethodType[]{MethodType.GETTER}), constraintValidatorClasses);
            BeanValidationDelegate.processExecutableDescriptor(descriptor.getConstrainedConstructors(), constraintValidatorClasses);
            BeanValidationDelegate.processPropertyDescriptors(descriptor.getConstrainedProperties(), constraintValidatorClasses);
            if (!constraintValidatorClasses.isEmpty() && BeanValidationDelegate.shouldProcess(clazz)) {
                validatedClasses.add(clazz);
            }
            ReflectionUtils.doWithFields(clazz, field -> {
                ResolvableType resolvableType;
                Class genericType;
                Class<?> type = field.getType();
                if ((Iterable.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Optional.class.isAssignableFrom(type)) && BeanValidationDelegate.shouldProcess(genericType = (resolvableType = ResolvableType.forField((Field)field)).getGeneric(new int[]{0}).toClass())) {
                    validatedClasses.add(clazz);
                    BeanValidationDelegate.processAheadOfTime(genericType, validatedClasses, constraintValidatorClasses);
                }
                if (Map.class.isAssignableFrom(type)) {
                    resolvableType = ResolvableType.forField((Field)field);
                    Class keyGenericType = resolvableType.getGeneric(new int[]{0}).toClass();
                    Class valueGenericType = resolvableType.getGeneric(new int[]{1}).toClass();
                    if (BeanValidationDelegate.shouldProcess(keyGenericType)) {
                        validatedClasses.add(clazz);
                        BeanValidationDelegate.processAheadOfTime(keyGenericType, validatedClasses, constraintValidatorClasses);
                    }
                    if (BeanValidationDelegate.shouldProcess(valueGenericType)) {
                        validatedClasses.add(clazz);
                        BeanValidationDelegate.processAheadOfTime(valueGenericType, validatedClasses, constraintValidatorClasses);
                    }
                }
            });
        }

        private static boolean shouldProcess(Class<?> clazz) {
            return !clazz.getCanonicalName().startsWith("java.");
        }

        private static void processExecutableDescriptor(Set<? extends ExecutableDescriptor> executableDescriptors, Collection<Class<? extends ConstraintValidator<?, ?>>> constraintValidatorClasses) {
            for (ExecutableDescriptor executableDescriptor : executableDescriptors) {
                for (ParameterDescriptor parameterDescriptor : executableDescriptor.getParameterDescriptors()) {
                    for (ConstraintDescriptor constraintDescriptor : parameterDescriptor.getConstraintDescriptors()) {
                        constraintValidatorClasses.addAll(constraintDescriptor.getConstraintValidatorClasses());
                    }
                    for (ContainerElementTypeDescriptor typeDescriptor : parameterDescriptor.getConstrainedContainerElementTypes()) {
                        for (ConstraintDescriptor constraintDescriptor : typeDescriptor.getConstraintDescriptors()) {
                            constraintValidatorClasses.addAll(constraintDescriptor.getConstraintValidatorClasses());
                        }
                    }
                }
            }
        }

        private static void processPropertyDescriptors(Set<PropertyDescriptor> propertyDescriptors, Collection<Class<? extends ConstraintValidator<?, ?>>> constraintValidatorClasses) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                for (ConstraintDescriptor constraintDescriptor : propertyDescriptor.getConstraintDescriptors()) {
                    constraintValidatorClasses.addAll(constraintDescriptor.getConstraintValidatorClasses());
                }
                for (ContainerElementTypeDescriptor typeDescriptor : propertyDescriptor.getConstrainedContainerElementTypes()) {
                    for (ConstraintDescriptor constraintDescriptor : typeDescriptor.getConstraintDescriptors()) {
                        constraintValidatorClasses.addAll(constraintDescriptor.getConstraintValidatorClasses());
                    }
                }
            }
        }
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final Collection<Class<?>> validatedClasses;
        private final Collection<Class<? extends ConstraintValidator<?, ?>>> constraintValidatorClasses;

        public AotContribution(Collection<Class<?>> validatedClasses, Collection<Class<? extends ConstraintValidator<?, ?>>> constraintValidatorClasses) {
            this.validatedClasses = validatedClasses;
            this.constraintValidatorClasses = constraintValidatorClasses;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ReflectionHints hints = generationContext.getRuntimeHints().reflection();
            for (Class<?> clazz : this.validatedClasses) {
                hints.registerType(clazz, new MemberCategory[]{MemberCategory.DECLARED_FIELDS});
            }
            for (Class<Object> clazz : this.constraintValidatorClasses) {
                hints.registerType(clazz, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
        }
    }
}

