/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.MethodType;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class BeanValidationBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final boolean isBeanValidationPresent = ClassUtils.isPresent((String)"jakarta.validation.Validation", (ClassLoader)BeanValidationBeanRegistrationAotProcessor.class.getClassLoader());

    BeanValidationBeanRegistrationAotProcessor() {
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (isBeanValidationPresent) {
            return BeanValidationDelegate.processAheadOfTime(registeredBean);
        }
        return null;
    }

    private static class BeanValidationDelegate {
        private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

        private BeanValidationDelegate() {
        }

        @Nullable
        public static BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
            BeanDescriptor descriptor = validator.getConstraintsForClass(registeredBean.getBeanClass());
            HashSet constraintDescriptors = new HashSet();
            for (MethodDescriptor methodDescriptor : descriptor.getConstrainedMethods(MethodType.NON_GETTER, new MethodType[]{MethodType.GETTER})) {
                for (ParameterDescriptor parameterDescriptor : methodDescriptor.getParameterDescriptors()) {
                    constraintDescriptors.addAll(parameterDescriptor.getConstraintDescriptors());
                }
            }
            for (ConstructorDescriptor constructorDescriptor : descriptor.getConstrainedConstructors()) {
                for (ParameterDescriptor parameterDescriptor : constructorDescriptor.getParameterDescriptors()) {
                    constraintDescriptors.addAll(parameterDescriptor.getConstraintDescriptors());
                }
            }
            for (PropertyDescriptor propertyDescriptor : descriptor.getConstrainedProperties()) {
                constraintDescriptors.addAll(propertyDescriptor.getConstraintDescriptors());
            }
            if (!constraintDescriptors.isEmpty()) {
                return new BeanValidationBeanRegistrationAotContribution(constraintDescriptors);
            }
            return null;
        }
    }

    private static class BeanValidationBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final Collection<ConstraintDescriptor<?>> constraintDescriptors;

        public BeanValidationBeanRegistrationAotContribution(Collection<ConstraintDescriptor<?>> constraintDescriptors) {
            this.constraintDescriptors = constraintDescriptors;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            for (ConstraintDescriptor<?> constraintDescriptor : this.constraintDescriptors) {
                for (Class constraintValidatorClass : constraintDescriptor.getConstraintValidatorClasses()) {
                    generationContext.getRuntimeHints().reflection().registerType(constraintValidatorClass, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            }
        }
    }
}

