/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListener;
import org.springframework.context.event.EventListenerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class EventListenerMethodProcessor
implements SmartInitializingSingleton,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private final EventExpressionEvaluator evaluator = new EventExpressionEvaluator();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)"ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        String[] allBeanNames;
        List<EventListenerFactory> factories = this.getEventListenerFactories();
        for (String beanName : allBeanNames = this.applicationContext.getBeanNamesForType(Object.class)) {
            if (ScopedProxyUtils.isScopedTarget((String)beanName)) continue;
            Class type = this.applicationContext.getType(beanName);
            try {
                this.processBean(factories, beanName, type);
            }
            catch (Throwable ex) {
                throw new BeanInitializationException("Failed to process @EventListener annotation on bean with name '" + beanName + "'", ex);
            }
        }
    }

    protected List<EventListenerFactory> getEventListenerFactories() {
        Map beans = this.applicationContext.getBeansOfType(EventListenerFactory.class);
        ArrayList<EventListenerFactory> allFactories = new ArrayList<EventListenerFactory>(beans.values());
        AnnotationAwareOrderComparator.sort(allFactories);
        return allFactories;
    }

    protected void processBean(List<EventListenerFactory> factories, String beanName, Class<?> targetType) {
        if (!this.nonAnnotatedClasses.contains(targetType)) {
            Method[] methods;
            LinkedHashSet<Method> annotatedMethods = new LinkedHashSet<Method>(1);
            block0: for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(targetType)) {
                EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
                if (eventListener == null) continue;
                for (EventListenerFactory factory : factories) {
                    if (!factory.supportsMethod(method)) continue;
                    ApplicationListener<?> applicationListener = factory.createApplicationListener(beanName, targetType, method);
                    if (applicationListener instanceof ApplicationListenerMethodAdapter) {
                        ((ApplicationListenerMethodAdapter)applicationListener).init(this.applicationContext, this.evaluator);
                    }
                    this.applicationContext.addApplicationListener(applicationListener);
                    annotatedMethods.add(method);
                    continue block0;
                }
            }
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetType);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No @EventListener annotations found on bean class: " + targetType));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(annotatedMethods.size() + " @EventListener methods processed on bean '" + beanName + "': " + annotatedMethods));
            }
        }
    }
}

