/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.InterfaceMaker;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Conventions;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.RefreshableScriptTargetSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ScriptFactoryPostProcessor
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware,
ResourceLoaderAware,
DisposableBean {
    public static final String INLINE_SCRIPT_PREFIX = "inline:";
    public static final String REFRESH_CHECK_DELAY_ATTRIBUTE = Conventions.getQualifiedAttributeName((Class)(class$org$springframework$scripting$support$ScriptFactoryPostProcessor == null ? (class$org$springframework$scripting$support$ScriptFactoryPostProcessor = ScriptFactoryPostProcessor.class$("org.springframework.scripting.support.ScriptFactoryPostProcessor")) : class$org$springframework$scripting$support$ScriptFactoryPostProcessor), (String)"refreshCheckDelay");
    private static final String SCRIPT_FACTORY_NAME_PREFIX = "scriptFactory.";
    private static final String SCRIPTED_OBJECT_NAME_PREFIX = "scriptedObject.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private long defaultRefreshCheckDelay = -1L;
    private AbstractBeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private DefaultListableBeanFactory scriptBeanFactory = new DefaultListableBeanFactory();
    static /* synthetic */ Class class$org$springframework$scripting$support$ScriptFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$scripting$ScriptFactory;
    static /* synthetic */ Class class$org$springframework$aop$TargetSource;

    public void setDefaultRefreshCheckDelay(long defaultRefreshCheckDelay) {
        this.defaultRefreshCheckDelay = defaultRefreshCheckDelay;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalStateException("ScriptFactoryPostProcessor must run in AbstractBeanFactory, not in " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
        this.scriptBeanFactory.setParentBeanFactory((BeanFactory)this.beanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) {
        if (!(class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory).isAssignableFrom(beanClass)) {
            return null;
        }
        String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
        if (!this.scriptBeanFactory.containsBeanDefinition(scriptedObjectBeanName)) {
            RootBeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
            String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
            this.scriptBeanFactory.registerBeanDefinition(scriptFactoryBeanName, (BeanDefinition)this.createScriptFactoryBeanDefinition(bd));
            ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory);
            ScriptSource scriptSource = this.convertToScriptSource(scriptFactory.getScriptSourceLocator(), this.resourceLoader);
            Object[] interfaces = scriptFactory.getScriptInterfaces();
            if (scriptFactory.requiresConfigInterface() && !bd.getPropertyValues().isEmpty()) {
                PropertyValue[] pvs = bd.getPropertyValues().getPropertyValues();
                Class configInterface = this.createConfigInterface(pvs, (Class[])interfaces);
                interfaces = (Class[])ObjectUtils.addObjectToArray((Object[])interfaces, (Object)configInterface);
            }
            RootBeanDefinition objectBd = this.createScriptedObjectBeanDefinition(bd, scriptFactoryBeanName, scriptSource, (Class[])interfaces);
            long refreshCheckDelay = this.resolveRefreshCheckDelay((BeanDefinition)bd);
            if (refreshCheckDelay >= 0L) {
                objectBd.setSingleton(false);
            }
            this.scriptBeanFactory.registerBeanDefinition(scriptedObjectBeanName, (BeanDefinition)objectBd);
            if (refreshCheckDelay >= 0L) {
                RefreshableScriptTargetSource ts = new RefreshableScriptTargetSource((BeanFactory)this.scriptBeanFactory, scriptedObjectBeanName, scriptSource);
                ts.setRefreshCheckDelay(this.defaultRefreshCheckDelay);
                return this.createRefreshableProxy((TargetSource)ts, (Class[])interfaces);
            }
        }
        return this.scriptBeanFactory.getBean(scriptedObjectBeanName);
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) {
        return true;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    protected long resolveRefreshCheckDelay(BeanDefinition bd) {
        Object attributeValue = bd.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (attributeValue instanceof Number) {
            return ((Number)attributeValue).longValue();
        }
        return this.defaultRefreshCheckDelay;
    }

    protected RootBeanDefinition createScriptFactoryBeanDefinition(RootBeanDefinition bd) {
        RootBeanDefinition scriptBd = new RootBeanDefinition(bd.getBeanClass());
        scriptBd.getConstructorArgumentValues().addArgumentValues(bd.getConstructorArgumentValues());
        return scriptBd;
    }

    protected ScriptSource convertToScriptSource(String scriptSourceLocator, ResourceLoader resourceLoader) {
        if (scriptSourceLocator.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(scriptSourceLocator.substring(INLINE_SCRIPT_PREFIX.length()));
        }
        return new ResourceScriptSource(resourceLoader.getResource(scriptSourceLocator));
    }

    protected Class createConfigInterface(PropertyValue[] pvs, Class[] interfaces) {
        Assert.notEmpty((Object[])pvs, (String)"Property values must not be empty");
        InterfaceMaker maker = new InterfaceMaker();
        for (int i = 0; i < pvs.length; ++i) {
            String propertyName = pvs[i].getName();
            Class propertyType = BeanUtils.findPropertyType((String)propertyName, (Class[])interfaces);
            String setterName = "set" + StringUtils.capitalize((String)propertyName);
            Signature signature = new Signature(setterName, Type.VOID_TYPE, new Type[]{Type.getType((Class)propertyType)});
            maker.add(signature, new Type[0]);
        }
        return maker.create();
    }

    protected RootBeanDefinition createScriptedObjectBeanDefinition(RootBeanDefinition bd, String scriptFactoryBeanName, ScriptSource scriptSource, Class[] interfaces) {
        RootBeanDefinition objectBd = new RootBeanDefinition(bd);
        objectBd.setBeanClass(null);
        objectBd.setFactoryBeanName(scriptFactoryBeanName);
        objectBd.setFactoryMethodName("getScriptedObject");
        objectBd.getConstructorArgumentValues().clear();
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)scriptSource);
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)interfaces);
        return objectBd;
    }

    protected Object createRefreshableProxy(TargetSource ts, Class[] interfaces) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(ts);
        if (interfaces == null) {
            interfaces = ClassUtils.getAllInterfacesForClass((Class)ts.getTargetClass());
        }
        proxyFactory.setInterfaces(interfaces);
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor((Object)ts);
        introduction.suppressInterface(class$org$springframework$aop$TargetSource == null ? (class$org$springframework$aop$TargetSource = ScriptFactoryPostProcessor.class$("org.springframework.aop.TargetSource")) : class$org$springframework$aop$TargetSource);
        proxyFactory.addAdvice((Advice)introduction);
        return proxyFactory.getProxy();
    }

    public void destroy() {
        this.scriptBeanFactory.destroySingletons();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

