/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CronTriggerFactoryBean
implements FactoryBean<CronTrigger>,
BeanNameAware,
InitializingBean {
    private static final Map<String, Integer> constants = Map.of("MISFIRE_INSTRUCTION_SMART_POLICY", 0, "MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY", -1, "MISFIRE_INSTRUCTION_FIRE_ONCE_NOW", 1, "MISFIRE_INSTRUCTION_DO_NOTHING", 2);
    private @Nullable String name;
    private @Nullable String group;
    private @Nullable JobDetail jobDetail;
    private JobDataMap jobDataMap = new JobDataMap();
    private @Nullable Date startTime;
    private long startDelay = 0L;
    private @Nullable String cronExpression;
    private @Nullable TimeZone timeZone;
    private @Nullable String calendarName;
    private int priority;
    private int misfireInstruction = 0;
    private @Nullable String description;
    private @Nullable String beanName;
    private @Nullable CronTrigger cronTrigger;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public JobDataMap getJobDataMap() {
        return this.jobDataMap;
    }

    public void setJobDataAsMap(Map<String, ?> jobDataAsMap) {
        this.jobDataMap.putAll(jobDataAsMap);
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setStartDelay(long startDelay) {
        Assert.isTrue((startDelay >= 0L ? 1 : 0) != 0, (String)"Start delay cannot be negative");
        this.startDelay = startDelay;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setMisfireInstruction(int misfireInstruction) {
        Assert.isTrue((boolean)constants.containsValue(misfireInstruction), (String)"Only values of misfire instruction constants allowed");
        this.misfireInstruction = misfireInstruction;
    }

    public void setMisfireInstructionName(String constantName) {
        Assert.hasText((String)constantName, (String)"'constantName' must not be null or blank");
        Integer misfireInstruction = constants.get(constantName);
        Assert.notNull((Object)misfireInstruction, (String)"Only misfire instruction constants allowed");
        this.misfireInstruction = misfireInstruction;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws ParseException {
        Assert.notNull((Object)this.cronExpression, (String)"Property 'cronExpression' is required");
        if (this.name == null) {
            this.name = this.beanName;
        }
        if (this.group == null) {
            this.group = "DEFAULT";
        }
        if (this.jobDetail != null) {
            this.jobDataMap.put("jobDetail", (Object)this.jobDetail);
        }
        if (this.startDelay > 0L || this.startTime == null) {
            this.startTime = new Date(System.currentTimeMillis() + this.startDelay);
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        CronTriggerImpl cti = new CronTriggerImpl();
        cti.setName(this.name != null ? this.name : this.toString());
        cti.setGroup(this.group);
        if (this.jobDetail != null) {
            cti.setJobKey(this.jobDetail.getKey());
        }
        cti.setJobDataMap(this.jobDataMap);
        cti.setStartTime(this.startTime);
        cti.setCronExpression(this.cronExpression);
        cti.setTimeZone(this.timeZone);
        cti.setCalendarName(this.calendarName);
        cti.setPriority(this.priority);
        cti.setMisfireInstruction(this.misfireInstruction);
        cti.setDescription(this.description);
        this.cronTrigger = cti;
    }

    public @Nullable CronTrigger getObject() {
        return this.cronTrigger;
    }

    public Class<?> getObjectType() {
        return CronTrigger.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

