/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.activation.FileTypeMap;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.mail.javamail.SmartMimeMessage;
import org.springframework.util.Assert;

public class JavaMailSenderImpl
implements JavaMailSender {
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    private static final String HEADER_MESSAGE_ID = "Message-ID";
    private Properties javaMailProperties = new Properties();
    private Session session;
    private String protocol = "smtp";
    private String host;
    private int port = -1;
    private String username;
    private String password;
    private String defaultEncoding;
    private FileTypeMap defaultFileTypeMap;

    public JavaMailSenderImpl() {
        ConfigurableMimeFileTypeMap fileTypeMap = new ConfigurableMimeFileTypeMap();
        fileTypeMap.afterPropertiesSet();
        this.defaultFileTypeMap = fileTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
        JavaMailSenderImpl javaMailSenderImpl = this;
        synchronized (javaMailSenderImpl) {
            this.session = null;
        }
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public synchronized void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public synchronized Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.javaMailProperties);
        }
        return this.session;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultFileTypeMap(FileTypeMap defaultFileTypeMap) {
        this.defaultFileTypeMap = defaultFileTypeMap;
    }

    public FileTypeMap getDefaultFileTypeMap() {
        return this.defaultFileTypeMap;
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(simpleMessages.length);
        SimpleMailMessage[] simpleMailMessageArray = simpleMessages;
        int n = simpleMessages.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleMailMessage simpleMessage = simpleMailMessageArray[n2];
            MimeMailMessage message = new MimeMailMessage(this.createMimeMessage());
            simpleMessage.copyTo(message);
            mimeMessages.add(message.getMimeMessage());
            ++n2;
        }
        this.doSend(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), simpleMessages);
    }

    public MimeMessage createMimeMessage() {
        return new SmartMimeMessage(this.getSession(), this.getDefaultEncoding(), this.getDefaultFileTypeMap());
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        try {
            return new MimeMessage(this.getSession(), contentStream);
        }
        catch (MessagingException ex) {
            throw new MailParseException("Could not parse raw MIME content", ex);
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        this.doSend(mimeMessages, null);
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    public void send(MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(mimeMessagePreparators.length);
            MimeMessagePreparator[] mimeMessagePreparatorArray = mimeMessagePreparators;
            int n = mimeMessagePreparators.length;
            int n2 = 0;
            while (n2 < n) {
                MimeMessagePreparator preparator = mimeMessagePreparatorArray[n2];
                MimeMessage mimeMessage = this.createMimeMessage();
                preparator.prepare(mimeMessage);
                mimeMessages.add(mimeMessage);
                ++n2;
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]));
        }
        catch (MailException ex) {
            throw ex;
        }
        catch (MessagingException ex) {
            throw new MailParseException(ex);
        }
        catch (IOException ex) {
            throw new MailPreparationException(ex);
        }
        catch (Exception ex) {
            throw new MailPreparationException(ex);
        }
    }

    protected void doSend(MimeMessage[] mimeMessages, Object[] originalMessages) throws MailException {
        LinkedHashMap<Object, Exception> failedMessages = new LinkedHashMap<Object, Exception>();
        try {
            Transport transport = this.getTransport(this.getSession());
            transport.connect(this.getHost(), this.getPort(), this.getUsername(), this.getPassword());
            try {
                int i = 0;
                while (i < mimeMessages.length) {
                    MimeMessage mimeMessage = mimeMessages[i];
                    try {
                        if (mimeMessage.getSentDate() == null) {
                            mimeMessage.setSentDate(new Date());
                        }
                        String messageId = mimeMessage.getMessageID();
                        mimeMessage.saveChanges();
                        if (messageId != null) {
                            mimeMessage.setHeader(HEADER_MESSAGE_ID, messageId);
                        }
                        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                    }
                    catch (MessagingException ex) {
                        MimeMessage original = originalMessages != null ? originalMessages[i] : mimeMessage;
                        failedMessages.put(original, (Exception)((Object)ex));
                    }
                    ++i;
                }
            }
            finally {
                transport.close();
            }
        }
        catch (AuthenticationFailedException ex) {
            throw new MailAuthenticationException(ex);
        }
        catch (MessagingException ex) {
            throw new MailSendException("Mail server connection failed", ex);
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(this.getProtocol());
    }
}

