/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.List;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.EndpointHandlerMethod;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryConfigurer;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.support.AllowDenyCollectionManager;

public class RetryTopicConfiguration {
    private final List<DestinationTopic.Properties> destinationTopicProperties;
    private final AllowDenyCollectionManager<String> topicAllowListManager;
    private final EndpointHandlerMethod dltHandlerMethod;
    private final TopicCreation kafkaTopicAutoCreationConfig;
    private final ListenerContainerFactoryResolver.Configuration factoryResolverConfig;
    private final ListenerContainerFactoryConfigurer.Configuration factoryConfigurerConfig;

    RetryTopicConfiguration(List<DestinationTopic.Properties> destinationTopicProperties, EndpointHandlerMethod dltHandlerMethod, TopicCreation kafkaTopicAutoCreationConfig, AllowDenyCollectionManager<String> topicAllowListManager, ListenerContainerFactoryResolver.Configuration factoryResolverConfig, ListenerContainerFactoryConfigurer.Configuration factoryConfigurerConfig) {
        this.destinationTopicProperties = destinationTopicProperties;
        this.dltHandlerMethod = dltHandlerMethod;
        this.kafkaTopicAutoCreationConfig = kafkaTopicAutoCreationConfig;
        this.topicAllowListManager = topicAllowListManager;
        this.factoryResolverConfig = factoryResolverConfig;
        this.factoryConfigurerConfig = factoryConfigurerConfig;
    }

    public boolean hasConfigurationForTopics(String[] topics) {
        return this.topicAllowListManager.areAllowed((String[])topics);
    }

    public TopicCreation forKafkaTopicAutoCreation() {
        return this.kafkaTopicAutoCreationConfig;
    }

    public ListenerContainerFactoryResolver.Configuration forContainerFactoryResolver() {
        return this.factoryResolverConfig;
    }

    public ListenerContainerFactoryConfigurer.Configuration forContainerFactoryConfigurer() {
        return this.factoryConfigurerConfig;
    }

    public EndpointHandlerMethod getDltHandlerMethod() {
        return this.dltHandlerMethod;
    }

    public List<DestinationTopic.Properties> getDestinationTopicProperties() {
        return this.destinationTopicProperties;
    }

    static class TopicCreation {
        private final boolean shouldCreateTopics;
        private final int numPartitions;
        private final short replicationFactor;

        TopicCreation(boolean shouldCreate, int numPartitions, short replicationFactor) {
            this.shouldCreateTopics = shouldCreate;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
        }

        TopicCreation() {
            this.shouldCreateTopics = true;
            this.numPartitions = 1;
            this.replicationFactor = 1;
        }

        TopicCreation(boolean shouldCreateTopics) {
            this.shouldCreateTopics = shouldCreateTopics;
            this.numPartitions = 1;
            this.replicationFactor = 1;
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public short getReplicationFactor() {
            return this.replicationFactor;
        }

        public boolean shouldCreateTopics() {
            return this.shouldCreateTopics;
        }
    }
}

