/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.config.FileWritingMessageHandlerFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class FileWritingMessageHandlerBeanDefinitionBuilder {
    FileWritingMessageHandlerBeanDefinitionBuilder() {
    }

    static BeanDefinitionBuilder configure(Element element, boolean expectReply, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FileWritingMessageHandlerFactoryBean.class);
        String directory = element.getAttribute("directory");
        String directoryExpression = element.getAttribute("directory-expression");
        if (!StringUtils.hasText((String)directory) && !StringUtils.hasText((String)directoryExpression)) {
            parserContext.getReaderContext().error("directory or directory-expression is required", (Object)element);
        } else if (StringUtils.hasText((String)directory) && StringUtils.hasText((String)directoryExpression)) {
            parserContext.getReaderContext().error("Either directory or directory-expression must be provided but not both", (Object)element);
        }
        if (StringUtils.hasText((String)directoryExpression)) {
            BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionBuilder.addConstructorArgValue((Object)directoryExpression);
            builder.addPropertyValue("directoryExpression", (Object)expressionBuilder.getBeanDefinition());
        }
        builder.addPropertyValue("expectReply", (Object)expectReply);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"append-new-line");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"delete-source-files");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"temporary-file-suffix");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"mode", (String)"fileExistsMode");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"buffer-size");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"flush-interval");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"flush-when-idle");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"flush-predicate");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"preserve-timestamp");
        String remoteFileNameGenerator = element.getAttribute("filename-generator");
        String remoteFileNameGeneratorExpression = element.getAttribute("filename-generator-expression");
        boolean hasRemoteFileNameGenerator = StringUtils.hasText((String)remoteFileNameGenerator);
        boolean hasRemoteFileNameGeneratorExpression = StringUtils.hasText((String)remoteFileNameGeneratorExpression);
        if (hasRemoteFileNameGenerator || hasRemoteFileNameGeneratorExpression) {
            if (hasRemoteFileNameGenerator && hasRemoteFileNameGeneratorExpression) {
                parserContext.getReaderContext().error("at most one of 'filename-generator-expression' or 'filename-generator' is allowed on file outbound adapter/gateway", (Object)element);
            }
            if (hasRemoteFileNameGenerator) {
                builder.addPropertyReference("fileNameGenerator", remoteFileNameGenerator);
            } else {
                BeanDefinitionBuilder fileNameGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultFileNameGenerator.class);
                fileNameGeneratorBuilder.addPropertyValue("expression", (Object)remoteFileNameGeneratorExpression);
                builder.addPropertyValue("fileNameGenerator", (Object)fileNameGeneratorBuilder.getBeanDefinition());
            }
        }
        return builder;
    }
}

