/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minidev.json.JSONArray;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class JsonPathLinkDiscoverer
implements LinkDiscoverer {
    private final String pathTemplate;
    private final List<MediaType> mediaTypes;

    public JsonPathLinkDiscoverer(String pathTemplate, MediaType ... mediaTypes) {
        Assert.hasText((String)pathTemplate, (String)"Path template must not be null!");
        Assert.notNull((Object)mediaTypes, (String)"Primary MediaType must not be null!");
        this.pathTemplate = pathTemplate;
        this.mediaTypes = Arrays.asList(mediaTypes);
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation relation, String representation) {
        return JsonPathLinkDiscoverer.firstOrEmpty(this.findLinksWithRel(relation, representation));
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation relation, InputStream representation) {
        return JsonPathLinkDiscoverer.firstOrEmpty(this.findLinksWithRel(relation, representation));
    }

    @Override
    public Links findLinksWithRel(LinkRelation relation, String representation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        try {
            Object parseResult = this.getExpression(relation).read(representation);
            return this.createLinksFrom(parseResult, relation);
        }
        catch (InvalidPathException e) {
            return Links.NONE;
        }
    }

    @Override
    public Links findLinksWithRel(LinkRelation relation, InputStream representation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        try {
            Object parseResult = this.getExpression(relation).read(representation);
            return this.createLinksFrom(parseResult, relation);
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
        catch (PathNotFoundException o_O) {
            return Links.NONE;
        }
    }

    public boolean supports(@NonNull MediaType delimiter) {
        return this.mediaTypes.stream().anyMatch(mediaType -> mediaType.isCompatibleWith(delimiter));
    }

    protected Link extractLink(Object element, LinkRelation rel) {
        return Link.of(element.toString(), rel);
    }

    private JsonPath getExpression(LinkRelation rel) {
        return JsonPath.compile((String)String.format(this.pathTemplate, rel.value()), (Predicate[])new Predicate[0]);
    }

    private Links createLinksFrom(Object parseResult, LinkRelation rel) {
        if (JSONArray.class.isInstance(parseResult)) {
            JSONArray jsonArray = (JSONArray)parseResult;
            return jsonArray.stream().flatMap(it -> JSONArray.class.isInstance(it) ? ((JSONArray)it).stream() : Stream.of(it)).map(it -> this.extractLink(it, rel)).collect(Links.collector());
        }
        return Links.of(Map.class.isInstance(parseResult) ? this.extractLink(parseResult, rel) : Link.of(parseResult.toString(), rel));
    }

    private static <T> Optional<T> firstOrEmpty(Iterable<T> source) {
        Iterator<T> iterator = source.iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }
}

