/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Properties;
import org.springframework.util.Assert;

public class ClusterInfo {
    private final Properties clusterProperties;

    public ClusterInfo(Properties clusterProperties) {
        Assert.notNull((Object)clusterProperties, (String)"ClusterProperties must not be null!");
        this.clusterProperties = clusterProperties;
    }

    public String getState() {
        return this.get(Info.STATE);
    }

    public Long getSlotsAssigned() {
        return this.getLongValueOf(Info.SLOTS_ASSIGNED);
    }

    public Long getSlotsOk() {
        return this.getLongValueOf(Info.SLOTS_OK);
    }

    public Long getSlotsPfail() {
        return this.getLongValueOf(Info.SLOTS_PFAIL);
    }

    public Long getSlotsFail() {
        return this.getLongValueOf(Info.SLOTS_FAIL);
    }

    public Long getKnownNodes() {
        return this.getLongValueOf(Info.KNOWN_NODES);
    }

    public Long getClusterSize() {
        return this.getLongValueOf(Info.SIZE);
    }

    public Long getCurrentEpoch() {
        return this.getLongValueOf(Info.CURRENT_EPOCH);
    }

    public Long getMessagesSent() {
        return this.getLongValueOf(Info.MESSAGES_SENT);
    }

    public Long getMessagesReceived() {
        return this.getLongValueOf(Info.MESSAGES_RECEIVED);
    }

    public String get(Info info) {
        Assert.notNull((Object)((Object)info), (String)"Cannot retrieve cluster information for 'null'.");
        return this.get(info.key);
    }

    public String get(String key) {
        Assert.hasText((String)key, (String)"Cannot get cluster information for 'empty' / 'null' key.");
        return this.clusterProperties.getProperty(key);
    }

    private Long getLongValueOf(Info info) {
        String value = this.get(info);
        return value == null ? null : Long.valueOf(value);
    }

    public String toString() {
        return this.clusterProperties.toString();
    }

    public static enum Info {
        STATE("cluster_state"),
        SLOTS_ASSIGNED("cluster_slots_assigned"),
        SLOTS_OK("cluster_slots_ok"),
        SLOTS_PFAIL("cluster_slots_pfail"),
        SLOTS_FAIL("cluster_slots_fail"),
        KNOWN_NODES("cluster_known_nodes"),
        SIZE("cluster_size"),
        CURRENT_EPOCH("cluster_current_epoch"),
        MY_EPOCH("cluster_my_epoch"),
        MESSAGES_SENT("cluster_stats_messages_sent"),
        MESSAGES_RECEIVED("cluster_stats_messages_received");

        String key;

        private Info(String key) {
            this.key = key;
        }
    }
}

