/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.util.Assert;

public class RelationshipHelper {
    private final Neo4jTemplate template;
    private final Direction direction;
    private final RelationshipType type;

    public RelationshipHelper(Neo4jTemplate template, Direction direction, RelationshipType type) {
        this.template = template;
        this.direction = direction;
        this.type = type;
    }

    private Iterable<Node> getOtherNodes(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        for (Relationship rel : node.getRelationships(this.type, this.direction)) {
            result.add(rel.getOtherNode(node));
        }
        return result;
    }

    protected Relationship obtainSingleRelationship(Node start, Node end) {
        Iterable existingRelationships = start.getRelationships(this.type, this.direction);
        for (Relationship existingRelationship : existingRelationships) {
            if (existingRelationship == null || !existingRelationship.getOtherNode(start).equals(end)) continue;
            return existingRelationship;
        }
        return start.createRelationshipTo(end, this.type);
    }

    protected Node checkAndGetNode(Object entity) {
        if (entity == null) {
            throw new IllegalStateException("Entity is null");
        }
        Node node = this.getNode(entity);
        if (node != null) {
            return node;
        }
        throw new IllegalStateException("Entity must have a backing Node");
    }

    protected void removeMissingRelationshipsInStoreAndKeepOnlyNewRelationShipsInSet(Node node, Set<Node> targetNodes, Class<?> targetType) {
        for (Relationship relationship : node.getRelationships(this.type, this.direction)) {
            if (targetNodes.remove(relationship.getOtherNode(node))) continue;
            if (targetType != null) {
                Object actualTargetType = relationship.getOtherNode(node).getProperty("__type__");
                try {
                    if (!targetType.isAssignableFrom(Class.forName((String)actualTargetType))) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(String.format("Could not read type '%s' - type does not exist", actualTargetType), e);
                }
            }
            this.template.delete(relationship);
        }
    }

    protected void createAddedRelationships(Node node, Set<Node> targetNodes) {
        for (Node targetNode : targetNodes) {
            this.createSingleRelationship(node, targetNode);
        }
    }

    protected Set<Node> createSetOfTargetNodes(Object newVal, Class<?> relatedType) {
        if (!(newVal instanceof Set)) {
            throw new IllegalArgumentException("New value must be a Set, was: " + newVal.getClass());
        }
        HashSet<Node> nodes = new HashSet<Node>();
        for (Object value : (Set)newVal) {
            if (!relatedType.isInstance(value)) {
                throw new IllegalArgumentException("New value elements must be " + relatedType);
            }
            nodes.add(this.getOrCreateState(value));
        }
        return nodes;
    }

    protected Node getOrCreateState(Object value) {
        Node Node2 = this.getNode(value);
        if (Node2 != null) {
            return Node2;
        }
        Object saved = this.template.save(value);
        Node newState = this.getNode(saved);
        Assert.notNull((Object)newState);
        return newState;
    }

    protected Set<Object> createEntitySetFromRelationshipEndNodes(Object entity, MappingPolicy mappingPolicy, Class<?> relatedType) {
        Iterable<Node> nodes = this.getStatesFromEntity(entity);
        HashSet<Object> result = new HashSet<Object>();
        for (Node otherNode : nodes) {
            Object target = this.template.createEntityFromState(otherNode, relatedType, mappingPolicy);
            result.add(target);
        }
        return result;
    }

    protected Relationship createSingleRelationship(Node start, Node end) {
        if (end == null) {
            return null;
        }
        switch (this.direction) {
            case OUTGOING: 
            case BOTH: {
                return this.obtainSingleRelationship(start, end);
            }
            case INCOMING: {
                return this.obtainSingleRelationship(end, start);
            }
        }
        throw new InvalidDataAccessApiUsageException("invalid direction " + this.direction);
    }

    protected Iterable<Node> getStatesFromEntity(Object entity) {
        Node node = this.getNode(entity);
        return this.getOtherNodes(node);
    }

    protected Node getNode(Object entity) {
        return (Node)this.template.getPersistentState(entity);
    }

    public Iterable<Relationship> getRelationships(Node node) {
        return node.getRelationships(this.type, this.direction);
    }

    public Relationship getSingleRelationship(Node node) {
        return node.getSingleRelationship(this.type, this.direction);
    }

    public RelationshipType getRelationshipType() {
        return this.type;
    }
}

