/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.MapResult;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.Neo4jTemplateAware;
import org.springframework.data.neo4j.support.conversion.QueryResultProxy;
import org.springframework.data.neo4j.support.path.ConvertingEntityPath;

public class EntityResultConverter<T, R>
extends DefaultConverter<T, R>
implements Neo4jTemplateAware<EntityResultConverter<T, R>> {
    private final ConversionService conversionService;
    private Neo4jTemplate template;

    public EntityResultConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public EntityResultConverter(ConversionService conversionService, Neo4jTemplate template) {
        this.conversionService = conversionService;
        this.template = template;
    }

    @Override
    public EntityResultConverter<T, R> with(Neo4jTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("Template for EntityResultConverter must not be null");
        }
        this.template = template;
        return this;
    }

    @Override
    protected Object doConvert(Object value, Class<?> sourceType, Class targetType, MappingPolicy mappingPolicy) {
        if (EntityPath.class.isAssignableFrom(targetType)) {
            return new ConvertingEntityPath(this.toPath(value, sourceType), this.template);
        }
        if (this.template.isNodeEntity(targetType)) {
            return this.template.projectTo(this.toNode(value, sourceType), targetType, mappingPolicy);
        }
        if (this.template.isRelationshipEntity(targetType)) {
            return this.template.projectTo(this.toRelationship(value, sourceType), targetType, mappingPolicy);
        }
        Object result = super.doConvert(value, sourceType, targetType, mappingPolicy);
        if (result != null) {
            return result;
        }
        if (this.conversionService.canConvert(sourceType, targetType)) {
            return this.conversionService.convert(value, targetType);
        }
        return result;
    }

    public R extractMapResult(Object value, Class returnType, MappingPolicy mappingPolicy) {
        if (!Map.class.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("MapResult can only be extracted from Map<String,Object>.");
        }
        QueryResultProxy handler = new QueryResultProxy((Map)value, mappingPolicy, this);
        return (R)Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler);
    }

    @Override
    public R convert(Object value, Class type, MappingPolicy mappingPolicy) {
        if (type.isAnnotationPresent(MapResult.class)) {
            return this.extractMapResult(value, type, mappingPolicy);
        }
        return super.convert(value, type, mappingPolicy);
    }
}

