/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import org.springframework.data.ldap.repository.query.AbstractLdapRepositoryQuery;
import org.springframework.data.ldap.repository.query.LdapQueryCreator;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.query.LdapQuery;

public class PartTreeLdapRepositoryQuery
extends AbstractLdapRepositoryQuery {
    private final PartTree partTree;
    private final Parameters<?, ?> parameters;
    private final ObjectDirectoryMapper objectDirectoryMapper;

    public PartTreeLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations) {
        super(queryMethod, entityType, ldapOperations);
        this.partTree = new PartTree(queryMethod.getName(), entityType);
        this.parameters = queryMethod.getParameters();
        this.objectDirectoryMapper = ldapOperations.getObjectDirectoryMapper();
    }

    @Override
    protected LdapQuery createQuery(Object[] actualParameters) {
        LdapQueryCreator queryCreator = new LdapQueryCreator(this.partTree, this.parameters, this.getEntityClass(), this.objectDirectoryMapper, actualParameters);
        return (LdapQuery)queryCreator.createQuery();
    }
}

