/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

public class BeanDefinitionUtils {
    public static Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, EntityManagerFactory.class, (boolean)true, (boolean)false)));
        for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, AbstractEntityManagerFactoryBean.class, (boolean)true, (boolean)false)) {
            names.add(BeanFactoryUtils.transformedBeanName((String)factoryBeanName));
        }
        return names;
    }

    public static Collection<EntityManagerFactoryBeanDefinition> getEntityManagerFactoryBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        ArrayList<EntityManagerFactoryBeanDefinition> definitions = new ArrayList<EntityManagerFactoryBeanDefinition>();
        for (Class type : Arrays.asList(EntityManagerFactory.class, AbstractEntityManagerFactoryBean.class)) {
            for (String name : beanFactory.getBeanNamesForType(type, true, false)) {
                String transformedName = BeanFactoryUtils.transformedBeanName((String)name);
                EntityManagerFactoryBeanDefinition definition = new EntityManagerFactoryBeanDefinition(transformedName, (BeanFactory)beanFactory, beanFactory.getBeanDefinition(transformedName));
                definitions.add(definition);
            }
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
            definitions.addAll(BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory));
        }
        return definitions;
    }

    public static BeanDefinition getBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(name);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return BeanDefinitionUtils.getBeanDefinition(name, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw o_O;
        }
    }

    public static class EntityManagerFactoryBeanDefinition {
        private final String beanName;
        private final BeanFactory beanFactory;
        private final BeanDefinition beanDefinition;

        public EntityManagerFactoryBeanDefinition(String beanName, BeanFactory beanFactory, BeanDefinition beanDefinition) {
            this.beanName = beanName;
            this.beanFactory = beanFactory;
            this.beanDefinition = beanDefinition;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public BeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        public BeanDefinition getBeanDefinition() {
            return this.beanDefinition;
        }
    }
}

