/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kotlin;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.reactor.ReactorContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.kotlin.KotlinContextElement;
import org.springframework.util.ClassUtils;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0001\u00a8\u0006\u0005"}, d2={"asContextElement", "Lkotlin/coroutines/CoroutineContext;", "Lorg/springframework/cloud/sleuth/Tracer;", "currentSpan", "Lorg/springframework/cloud/sleuth/Span;", "spring-cloud-sleuth-instrumentation"})
public final class AsContextElementKt {
    @NotNull
    public static final CoroutineContext asContextElement(@NotNull Tracer $this$asContextElement) {
        Intrinsics.checkNotNullParameter((Object)$this$asContextElement, (String)"<this>");
        return (CoroutineContext)new KotlinContextElement($this$asContextElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Span currentSpan(@NotNull CoroutineContext $this$currentSpan) {
        Intrinsics.checkNotNullParameter((Object)$this$currentSpan, (String)"<this>");
        CoroutineContext.Key<KotlinContextElement> key = KotlinContextElement.KEY;
        Intrinsics.checkNotNullExpressionValue(key, (String)"KEY");
        KotlinContextElement element = (KotlinContextElement)$this$currentSpan.get(key);
        if (element != null) {
            return element.getSpan();
        }
        if (!ClassUtils.isPresent((String)"kotlinx.coroutines.reactor.ReactorContext", null)) {
            return null;
        }
        ReactorContext reactorContext = (ReactorContext)$this$currentSpan.get((CoroutineContext.Key)ReactorContext.Key);
        if (reactorContext != null) {
            if (reactorContext.getContext().hasKey(Span.class)) {
                return (Span)reactorContext.getContext().get(Span.class);
            }
            if (reactorContext.getContext().hasKey(TraceContext.class) && reactorContext.getContext().hasKey(Tracer.class) && reactorContext.getContext().hasKey(CurrentTraceContext.class)) {
                Object object = reactorContext.getContext().get(TraceContext.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reactorContext.context.g\u2026TraceContext::class.java)");
                TraceContext traceContext = (TraceContext)object;
                Closeable closeable = (Closeable)((CurrentTraceContext)reactorContext.getContext().get(CurrentTraceContext.class)).maybeScope(traceContext);
                Throwable throwable = null;
                try {
                    CurrentTraceContext.Scope it = (CurrentTraceContext.Scope)closeable;
                    boolean bl = false;
                    Span span = ((Tracer)reactorContext.getContext().get(Tracer.class)).currentSpan();
                    return span;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if (reactorContext.getContext().hasKey(Tracer.class)) {
                return ((Tracer)reactorContext.getContext().get(Tracer.class)).currentSpan();
            }
        }
        return null;
    }
}

