/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.stats;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.util.StringUtils;

final class LoadBalancerTags {
    static final String UNKNOWN = "UNKNOWN";

    private LoadBalancerTags() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    static Iterable<Tag> buildSuccessRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        ServiceInstance serviceInstance = (ServiceInstance)completionContext.getLoadBalancerResponse().getServer();
        Tags tags = Tags.of(LoadBalancerTags.buildServiceInstanceTags(serviceInstance));
        Object clientResponse = completionContext.getClientResponse();
        if (clientResponse instanceof ResponseData) {
            ResponseData responseData = (ResponseData)clientResponse;
            RequestData requestData = responseData.getRequestData();
            tags = requestData != null ? tags.and(new Tag[]{LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", LoadBalancerTags.getPath(requestData))}) : tags.and(new Tag[]{Tag.of((String)"method", (String)UNKNOWN), Tag.of((String)"uri", (String)UNKNOWN)});
            tags = tags.and(new Tag[]{Tag.of((String)"outcome", (String)LoadBalancerTags.forStatus(LoadBalancerTags.statusValue(responseData))), LoadBalancerTags.valueOrUnknown("status", LoadBalancerTags.statusValue(responseData))});
        } else {
            tags = tags.and(new Tag[]{Tag.of((String)"method", (String)UNKNOWN), Tag.of((String)"uri", (String)UNKNOWN), Tag.of((String)"outcome", (String)UNKNOWN), Tag.of((String)"status", (String)UNKNOWN)});
        }
        return tags;
    }

    private static int statusValue(ResponseData responseData) {
        return responseData.getHttpStatus() != null ? responseData.getHttpStatus().value() : 200;
    }

    private static String getPath(RequestData requestData) {
        return requestData.getUrl() != null ? requestData.getUrl().getPath() : UNKNOWN;
    }

    static Iterable<Tag> buildDiscardedRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        RequestData requestData;
        if (completionContext.getLoadBalancerRequest().getContext() instanceof RequestDataContext && (requestData = ((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).getClientRequest()) != null) {
            return Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", LoadBalancerTags.getPath(requestData)), LoadBalancerTags.valueOrUnknown("serviceId", LoadBalancerTags.getHost(requestData))});
        }
        return Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", UNKNOWN), LoadBalancerTags.valueOrUnknown("uri", UNKNOWN), LoadBalancerTags.valueOrUnknown("serviceId", UNKNOWN)});
    }

    private static String getHost(RequestData requestData) {
        return requestData.getUrl() != null ? requestData.getUrl().getHost() : UNKNOWN;
    }

    static Iterable<Tag> buildFailedRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        RequestData requestData;
        ServiceInstance serviceInstance = (ServiceInstance)completionContext.getLoadBalancerResponse().getServer();
        Tags tags = Tags.of(LoadBalancerTags.buildServiceInstanceTags(serviceInstance)).and(new Tag[]{LoadBalancerTags.exception(completionContext.getThrowable())});
        if (completionContext.getLoadBalancerRequest().getContext() instanceof RequestDataContext && (requestData = ((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).getClientRequest()) != null) {
            return tags.and((Iterable)Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", LoadBalancerTags.getPath(requestData))}));
        }
        return tags.and((Iterable)Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", UNKNOWN), LoadBalancerTags.valueOrUnknown("uri", UNKNOWN)}));
    }

    static Iterable<Tag> buildServiceInstanceTags(ServiceInstance serviceInstance) {
        return Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("serviceId", serviceInstance.getServiceId()), LoadBalancerTags.valueOrUnknown("serviceInstance.instanceId", serviceInstance.getInstanceId()), LoadBalancerTags.valueOrUnknown("serviceInstance.host", serviceInstance.getHost()), LoadBalancerTags.valueOrUnknown("serviceInstance.port", String.valueOf(serviceInstance.getPort()))});
    }

    private static Tag valueOrUnknown(String key, String value) {
        if (value != null) {
            return Tag.of((String)key, (String)value);
        }
        return Tag.of((String)key, (String)UNKNOWN);
    }

    private static Tag valueOrUnknown(String key, Object value) {
        if (value != null) {
            return Tag.of((String)key, (String)String.valueOf(value));
        }
        return Tag.of((String)key, (String)UNKNOWN);
    }

    private static Tag exception(Throwable exception) {
        if (exception != null) {
            String simpleName = exception.getClass().getSimpleName();
            return Tag.of((String)"exception", (String)(StringUtils.hasText((String)simpleName) ? simpleName : exception.getClass().getName()));
        }
        return Tag.of((String)"exception", (String)"None");
    }

    public static String forStatus(int status) {
        if (status >= 100 && status < 200) {
            return "INFORMATIONAL";
        }
        if (status >= 200 && status < 300) {
            return "SUCCESS";
        }
        if (status >= 300 && status < 400) {
            return "REDIRECTION";
        }
        if (status >= 400 && status < 500) {
            return "CLIENT_ERROR";
        }
        if (status >= 500 && status < 600) {
            return "SERVER_ERROR";
        }
        return UNKNOWN;
    }
}

