/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodMetadata;
import org.springframework.cloud.contract.verifier.builder.NameProvider;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class SpockMethodMetadata
implements MethodMetadata {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData metaData;
    private final NameProvider nameProvider = new NameProvider();

    SpockMethodMetadata(BlockBuilder blockBuilder, GeneratedClassMetaData metaData) {
        this.blockBuilder = blockBuilder;
        this.metaData = metaData;
    }

    @Override
    public MethodMetadata name(SingleContractMetadata metaData) {
        this.blockBuilder.addAtTheEnd(this.nameProvider.methodName(metaData));
        return this;
    }

    @Override
    public MethodMetadata modifier() {
        return this;
    }

    @Override
    public MethodMetadata returnType() {
        this.blockBuilder.addIndented("def");
        return this;
    }

    @Override
    public boolean accept() {
        return this.metaData.configProperties.getTestFramework() == TestFramework.SPOCK;
    }
}

