/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.List;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.util.SerializationUtils;

interface BodyMethodGeneration {
    default public Object cloneBody(Object object) {
        byte[] serializedObject = SerializationUtils.serialize((Object)object);
        return SerializationUtils.deserialize((byte[])serializedObject);
    }

    default public void addColonIfRequired(Optional<String> lineSuffix, BlockBuilder blockBuilder) {
        lineSuffix.ifPresent(s -> blockBuilder.addAtTheEnd((String)lineSuffix.get()));
    }

    default public void addBodyMatchingBlock(List<BodyMatcher> matchers, BlockBuilder blockBuilder, Object responseBody, boolean shouldCommentOutBDDBlocks) {
        blockBuilder.endBlock();
        blockBuilder.addLine(this.getAssertionJoiner(shouldCommentOutBDDBlocks));
        blockBuilder.startBlock();
        matchers.forEach(it -> {
            if (it.matchingType() == MatchingType.NULL) {
                this.methodForNullCheck((BodyMatcher)it, blockBuilder);
            } else if (MatchingType.regexRelated((MatchingType)it.matchingType()) || it.matchingType() == MatchingType.EQUALITY) {
                this.methodForEqualityCheck((BodyMatcher)it, blockBuilder, responseBody);
            } else if (it.matchingType() == MatchingType.COMMAND) {
                this.methodForCommandExecution((BodyMatcher)it, blockBuilder, responseBody);
            } else {
                this.methodForTypeCheck((BodyMatcher)it, blockBuilder, responseBody);
            }
        });
    }

    default public String quotedAndEscaped(String string) {
        return "\"" + StringEscapeUtils.escapeJava((String)string) + "\"";
    }

    public void methodForNullCheck(BodyMatcher var1, BlockBuilder var2);

    public void methodForEqualityCheck(BodyMatcher var1, BlockBuilder var2, Object var3);

    public void methodForCommandExecution(BodyMatcher var1, BlockBuilder var2, Object var3);

    public void methodForTypeCheck(BodyMatcher var1, BlockBuilder var2, Object var3);

    default public String getAssertionJoiner(boolean shouldCommentOutBDDBlocks) {
        return shouldCommentOutBDDBlocks ? "// and:" : "and:";
    }
}

