/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.cloud.bootstrap.BootstrapApplicationListener;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class ContextRefresher {
    private static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    private static final String[] DEFAULT_PROPERTY_SOURCES = new String[]{"commandLineArgs", "defaultProperties"};
    private Set<String> standardSources = new HashSet<String>(Arrays.asList("systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams", "configurationProperties"));
    private ConfigurableApplicationContext context;
    private RefreshScope scope;

    public ContextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        this.context = context;
        this.scope = scope;
    }

    public synchronized Set<String> refresh() {
        Map<String, Object> before = this.extract(this.context.getEnvironment().getPropertySources());
        this.addConfigFilesToEnvironment();
        Set<String> keys = this.changes(before, this.extract(this.context.getEnvironment().getPropertySources())).keySet();
        this.context.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(this.context, keys));
        this.scope.refreshAll();
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurableApplicationContext addConfigFilesToEnvironment() {
        ConfigurableApplicationContext capture = null;
        try {
            StandardEnvironment environment = this.copyEnvironment(this.context.getEnvironment());
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Empty.class}).bannerMode(Banner.Mode.OFF).web(WebApplicationType.NONE).environment((ConfigurableEnvironment)environment);
            builder.application().setListeners(Arrays.asList(new BootstrapApplicationListener(), new ConfigFileApplicationListener()));
            capture = builder.run(new String[0]);
            if (environment.getPropertySources().contains(REFRESH_ARGS_PROPERTY_SOURCE)) {
                environment.getPropertySources().remove(REFRESH_ARGS_PROPERTY_SOURCE);
            }
            MutablePropertySources target = this.context.getEnvironment().getPropertySources();
            String targetName = null;
            for (PropertySource source : environment.getPropertySources()) {
                String name = source.getName();
                if (target.contains(name)) {
                    targetName = name;
                }
                if (this.standardSources.contains(name)) continue;
                if (target.contains(name)) {
                    target.replace(name, source);
                    continue;
                }
                if (targetName != null) {
                    target.addAfter(targetName, source);
                    continue;
                }
                target.addFirst(source);
                targetName = name;
            }
        }
        finally {
            for (ConfigurableApplicationContext closeable = capture; closeable != null; closeable = (ConfigurableApplicationContext)closeable.getParent()) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
                if (!(closeable.getParent() instanceof ConfigurableApplicationContext)) break;
            }
        }
        return capture;
    }

    private StandardEnvironment copyEnvironment(ConfigurableEnvironment input) {
        StandardEnvironment environment = new StandardEnvironment();
        MutablePropertySources capturedPropertySources = environment.getPropertySources();
        for (String name : DEFAULT_PROPERTY_SOURCES) {
            if (!input.getPropertySources().contains(name)) continue;
            if (capturedPropertySources.contains(name)) {
                capturedPropertySources.replace(name, input.getPropertySources().get(name));
                continue;
            }
            capturedPropertySources.addLast(input.getPropertySources().get(name));
        }
        environment.setActiveProfiles(input.getActiveProfiles());
        environment.setDefaultProfiles(input.getDefaultProfiles());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spring.jmx.enabled", false);
        map.put("spring.main.sources", "");
        capturedPropertySources.addFirst((PropertySource)new MapPropertySource(REFRESH_ARGS_PROPERTY_SOURCE, map));
        return environment;
    }

    private Map<String, Object> changes(Map<String, Object> before, Map<String, Object> after) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : before.keySet()) {
            if (!after.containsKey(key)) {
                result.put(key, null);
                continue;
            }
            if (this.equal(before.get(key), after.get(key))) continue;
            result.put(key, after.get(key));
        }
        for (String key : after.keySet()) {
            if (before.containsKey(key)) continue;
            result.put(key, after.get(key));
        }
        return result;
    }

    private boolean equal(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    private Map<String, Object> extract(MutablePropertySources propertySources) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            if (this.standardSources.contains(source.getName())) continue;
            this.extract(source, result);
        }
        return result;
    }

    private void extract(PropertySource<?> parent, Map<String, Object> result) {
        if (parent instanceof CompositePropertySource) {
            try {
                ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
                for (PropertySource source : ((CompositePropertySource)parent).getPropertySources()) {
                    sources.add(0, source);
                }
                for (PropertySource source : sources) {
                    this.extract(source, result);
                }
            }
            catch (Exception e) {
                return;
            }
        } else if (parent instanceof EnumerablePropertySource) {
            for (String key : ((EnumerablePropertySource)parent).getPropertyNames()) {
                result.put(key, parent.getProperty(key));
            }
        }
    }

    @Configuration
    protected static class Empty {
        protected Empty() {
        }
    }
}

