/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet;

import org.springframework.util.Assert;

public final class ContextPath {
    public static final ContextPath DEFAULT = ContextPath.of("");
    private final String path;

    private ContextPath(String path) {
        this.path = path;
    }

    public static ContextPath of(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"'contextPath' must not be null");
        if (!contextPath.isEmpty()) {
            if ("/".equals(contextPath)) {
                throw new IllegalArgumentException("Root context path must be specified using an empty string");
            }
            if (!contextPath.startsWith("/") || contextPath.endsWith("/")) {
                throw new IllegalArgumentException("Context path must start with '/' and not end with '/'");
            }
        }
        return new ContextPath(contextPath);
    }

    public String toString() {
        return this.path;
    }
}

