/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public class BuilderException
extends RuntimeException {
    private final @Nullable String operation;
    private final int statusCode;

    BuilderException(@Nullable String operation, int statusCode) {
        super(BuilderException.buildMessage(operation, statusCode));
        this.operation = operation;
        this.statusCode = statusCode;
    }

    public @Nullable String getOperation() {
        return this.operation;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private static String buildMessage(@Nullable String operation, int statusCode) {
        StringBuilder message = new StringBuilder("Builder");
        if (StringUtils.hasLength((String)operation)) {
            message.append(" lifecycle '").append(operation).append("'");
        }
        message.append(" failed with status code ").append(statusCode);
        return message.toString();
    }
}

