/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.JettyResourceFactory;

class JettyClientHttpConnectorFactory
implements ClientHttpConnectorFactory<JettyClientHttpConnector> {
    private final JettyResourceFactory jettyResourceFactory;

    JettyClientHttpConnectorFactory(JettyResourceFactory jettyResourceFactory) {
        this.jettyResourceFactory = jettyResourceFactory;
    }

    @Override
    public JettyClientHttpConnector createClientHttpConnector(SslBundle sslBundle) {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        if (sslBundle != null) {
            SslOptions options = sslBundle.getOptions();
            if (options.getCiphers() != null) {
                sslContextFactory.setIncludeCipherSuites(options.getCiphers());
                sslContextFactory.setExcludeCipherSuites(new String[0]);
            }
            if (options.getEnabledProtocols() != null) {
                sslContextFactory.setIncludeProtocols(options.getEnabledProtocols());
                sslContextFactory.setExcludeProtocols(new String[0]);
            }
            sslContextFactory.setSslContext(sslBundle.createSslContext());
        }
        ClientConnector connector = new ClientConnector();
        connector.setSslContextFactory(sslContextFactory);
        HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP(connector);
        HttpClient httpClient = new HttpClient((HttpClientTransport)transport);
        return new JettyClientHttpConnector(httpClient, this.jettyResourceFactory);
    }
}

